#ifndef _SYN_DEFS_H_
#define _SYN_DEFS_H_
#include <math.h>
//#include <stdint.h>
#include "notetable.h"
#define NOTEOFF 5

typedef float sample_t;
#define S_SAMPLERATE 44100
#define S_CHANNELS 2

//not needed bicoz of kikka
//#if defined(WIN32)
//#include "stdint.h"
//#endif

#ifdef SYN_DEBUG
#include <stdio.h>
#define DBG(x) x
#else
#define DBG(x)
#endif

#ifndef IFUNCTION
#define IFUNCTION
#endif
#ifndef IVARIABLE
#define IVARIABLE
#endif

#define S_NUM_DELAYS 12
#define S_NUM_TRACKS 5
#define S_FILTER_DEG 2

#define S_SONG_PATTERNS 92
#define S_NUM_PATTERNS 33
#define S_PATTERN_LEN 8
#define S_TICKLEN (3950 * 2)
#define S_DELAY_LEN_MAX 13000

#define S_FADE1 0.0001

#define S_SONGLEN (S_TICKLEN * S_PATTERN_LEN * S_SONG_PATTERNS)

// synth params & song data

typedef struct {
    // current delay line length
    int len;
    // curr pos in buf
    int pos;
    // IIR filter coeffs
    //sample_t filter[S_FILTER_DEG];
    sample_t f1;
    sample_t f2;
    // delay line
    //sample_t line[S_DELAY_LEN_MAX];
    
} DelayLine;

// delaylines
IVARIABLE sample_t lines[S_DELAY_LEN_MAX * S_NUM_DELAYS];

#if defined(USE_LD)
#define PATTERN_SIZE_OPTIMIZE 0
#else
// excess memory after end of array seems to contain 0 on FreeBSD
#define PATTERN_SIZE_OPTIMIZE -8
#endif
IVARIABLE int patterns[S_NUM_PATTERNS * S_PATTERN_LEN * 2 + PATTERN_SIZE_OPTIMIZE] = {

2 + ( 1 << 4), D_1, // 0
3 + ( 1 << 4), A_1,
2 + ( NOTEOFF << 4), 0,
3 + ( NOTEOFF << 4), 0,

3 + ( NOTEOFF << 4), 0,
2 + ( 1 << 4), F_1,
3 + ( 1 << 4), C_2,
3 + ( NOTEOFF << 4), 0,

5 + ( 2 << 4), D_1, // 1
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
5 + ( 2 << 4), D_1,

5 + ( NOTEOFF << 4), 0,
5 + ( 2 << 4), D_2,
5 + ( 2 << 4), A_0,
5 + ( 2 << 4), A_1,

8 + ( 2 << 4), A_2, // 2
8 + ( 2 << 4), D_3,
8 + ( 2 << 4), G_3,
0 + ( 0 << 4), 0,

0 + ( 0 << 4), 0,
8 + ( 2 << 4), A_3,
8 + ( 2 << 4), G_3,
8 + ( 2 << 4), D_3,

// 3
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

2 + ( 1 << 4), E_3,
3 + ( 1 << 4), E_4,
3 + ( NOTEOFF << 4), 3 + (NOTEOFF << 4),
2 + ( NOTEOFF << 4), 2 + (NOTEOFF << 4),

// 4
8 + ( 2 << 4), A_2,
8 + ( 2 << 4), G_2,
8 + ( 2 << 4), A_2,
8 + ( 2 << 4), D_3,

0 + ( 0 << 4), 0,
8 + ( 2 << 4), G_3,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

2 + ( 1 << 4), F_1, // 5
3 + ( 1 << 4), C_2,
2 + ( 1 << 4), F_2,
3 + ( 1 << 4), A_2,

0 + ( 0 << 4), 0,
2 + ( 1 << 4), C_3,
0 + ( 0 << 4), 0,
3 + ( 1 << 4), D_3,

5 + ( 2 << 4), F_1, // 6
0 + ( 0 << 4), 0,
5 + ( 2 << 4), F_1,
5 + ( 2 << 4), F_0,

5 + ( 3 << 4), C_1,
5 + ( 2 << 4), F_2,
5 + ( 2 << 4), C_3,
5 + ( 2 << 4), F_2,

// 7
7 + ( 3 << 4), S_TICKLEN,
7 + ( NOTEOFF << 4), 0,
7 + ( 3 << 4), S_TICKLEN * 1.5,
7 + ( NOTEOFF << 4), 0,

0 + ( 0 << 4), 0,
7 + ( 3 << 4), S_TICKLEN,
7 + ( 3 << 4), S_TICKLEN * 1.5,
7 + ( NOTEOFF << 4), 0,

// 8 hh
9 + ( 4 << 4), 700,
9 + ( 4 << 4), 700,
9 + ( 4 << 4), 1000,
9 + ( 4 << 4), 700,

9 + ( 4 << 4), 700,
9 + ( 4 << 4), 700,
9 + ( 4 << 4), 4000,
9 + ( 4 << 4), 1000,

// 9
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
9 + ( 4 << 4), 700,
9 + ( NOTEOFF << 4), 700,

0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
9 + ( 4 << 4), 700,
9 + ( NOTEOFF << 4), 700,

5 + ( 2 << 4), D_1,     // 10
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

0 + ( 0 << 4), 0, // 11 blank flank
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

5 + ( 2 << 4), As_0,     // 12
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

5 + ( 2 << 4), A_0,     // 13
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

// 14
5 + ( 2 << 4), A_0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
5 + ( 2 << 4), A_1,

0 + ( 0 << 4), 0,
5 + ( 2 << 4), G_2,
5 + ( 3 << 4), G_1,
5 + ( 0 << 4), C_1,

5 + ( 2 << 4), G_0,     // 15
0 + ( 0 << 4), 0,
2 + ( 1 << 4), G_1,
5 + ( 3 << 4), G_1,

5 + ( 2 << 4), G_1,
5 + ( 3 << 4), G_0,
5 + ( 2 << 4), G_2,
5 + ( 0 << 4), C_2,

5 + ( 2 << 4), As_0, // 16 b a#
0 + ( 0 << 4), 0,
5 + ( 2 << 4), As_0,
5 + ( 2 << 4), As_0,

5 + ( NOTEOFF << 4), 0,
5 + ( 2 << 4), F_0,
0 + ( 0 << 4), 0,
5 + ( 2 << 4), As_1,

2 + ( 1 << 4), D_3, // 17 gmel
3 + ( 1 << 4), D_4,
0 + ( 0 << 4), 0,
2 + ( NOTEOFF << 4), 2 + (NOTEOFF << 4),

3 + ( NOTEOFF << 4), 2 + (NOTEOFF << 4),
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

// 18
2 + ( NOTEOFF << 4), 0,
3 + ( NOTEOFF << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

5 + ( 2 << 4), G_0,     // 19
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

0 + ( 0 << 4), 0,
5 + ( NOTEOFF << 4), 0,
5 + ( 2 << 4), G_1,
5 + ( 2 << 4), G_2,

2 + ( 1 << 4), D_3, // 20
3 + ( 1 << 4), C_3,
2 + ( 1 << 4), G_2,
0 + ( 0 << 4), 0,

0 + ( 0 << 4), 0,
3 + ( 1 << 4), G_2,
2 + ( 1 << 4), C_3,
3 + ( 1 << 4), G_3,

2 + ( 1 << 4), G_2, // 21
3 + ( 1 << 4), H_2,
2 + ( 1 << 4), D_3,
0 + ( 0 << 4), 0,

0 + ( 0 << 4), 0,
3 + ( 1 << 4), D_3,
2 + ( 1 << 4), H_2,
3 + ( 1 << 4), G_2,

// 22
7 + ( 3 << 4), S_TICKLEN,
7 + ( 3 << 4), S_TICKLEN,
7 + ( 3 << 4), S_TICKLEN,
7 + ( 3 << 4), S_TICKLEN,
7 + ( 3 << 4), S_TICKLEN,
7 + ( 3 << 4), S_TICKLEN,
7 + ( 3 << 4), S_TICKLEN,
7 + ( 3 << 4), S_TICKLEN,

// 23
7 + ( 3 << 4), S_TICKLEN,
7 + ( 3 << 4), S_TICKLEN,
7 + ( NOTEOFF << 4), 0,
2 + ( NOTEOFF << 4), 0,

3 + ( NOTEOFF << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

5 + ( 2 << 4), G_0,     // 24
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
5 + ( NOTEOFF << 4), 0,

0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

5 + ( 2 << 4), A_0,     // 25
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
5 + ( NOTEOFF << 4), 0,

0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

2 + ( 1 << 4), C_2,      // 26
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

0 + ( 0 << 4), 0, // 27
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

0 + ( 0 << 4), 0,
8 + ( 2 << 4), F_3,
8 + ( 2 << 4), E_3,
8 + ( 2 << 4), C_3,

2 + ( 1 << 4), C_3, // 28 gmel
3 + ( 1 << 4), C_4,
0 + ( 0 << 4), 0,
2 + ( NOTEOFF << 4), 2 + (NOTEOFF << 4),

3 + ( NOTEOFF << 4), 2 + (NOTEOFF << 4),
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

// 29
5 + ( 2 << 4), D_1,
0 + ( 0 << 4), 0,
5 + ( NOTEOFF << 4), 0,
0 + ( 0 << 4), 0,

0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,

// 30
2 + ( 1 << 4), As_1,
3 + ( 1 << 4), F_2,
2 + ( 1 << 4), D_2,
3 + ( 1 << 4), A_3,

0 + ( 0 << 4), 0,
2 + ( 1 << 4), As_1,
3 + ( 1 << 4), F_2,
2 + ( 0 << 4), As_2,

// 31
2 + ( 1 << 4), D_3,
3 + ( 1 << 4), F_3,
2 + ( 1 << 4), As_2,
3 + ( 1 << 4), As_1,

0 + ( 0 << 4), 0,
2 + ( 1 << 4), As_3,
3 + ( 1 << 4), F_2,
2 + ( 1 << 4), As_1,

2 + ( 1 << 4), As_2, // 32
3 + ( 1 << 4), F_3,
3 + ( NOTEOFF << 4), 2 + (NOTEOFF << 4),
2 + ( NOTEOFF << 4), 2 + (NOTEOFF << 4),

#if defined(USE_LD)
// excess memory after end of array seems to contain 0 on FreeBSD
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
0 + ( 0 << 4), 0,
#endif
};

IVARIABLE char song[S_NUM_TRACKS * S_SONG_PATTERNS] = {
    
    // gui
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 20, 20,
    18, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
    0,  0,  5,  5,  0,  0,  5,  5,  0,  0,  5,  5,  20, 20, 21, 21,
    11, 11, 26, 11,
    18, 11, 11, 11, 11, 11, 11, 11, 17, 3, 11, 28, 32, 3, 17, 11,
    0,  0,  5,  5,  0,  0,  30,  31,  0,  0,  5,  5,  20, 20, 21, 21,
    26, 11, 11, 11, 17, 11, 11, 11,

    // bass
    10, 12, 13, 14, 10, 12, 13, 14, 10, 12, 13, 13, 19, 19, 19, 11,
    1,  1,  6,  6,  1,  1,  6,  6,  1,  1,  6,  6,  19, 19, 19, 15,
    1,  1,  6,  6,  1,  1,  6,  6,  1,  1,  6,  6,  19, 19, 19, 15,
    24, 11, 25, 11,
    1,  1,  6,  6,  16, 16, 19, 15, 1,  1,  6,  6,  16, 16, 19, 15,
    1,  1,  6,  6,  1,  1,  16,  16,  1,  1,  6,  6,  19, 19, 19, 19,
    1,  1,  1,  1,  29,  11, 11, 11,
    
    // plim
    2,  11,  4, 11,  2,  11,  2, 4, 2,  11,  4, 11,  2,  11,  2, 4,
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11,
    11, 11, 11, 27,
    2,  4,  2,  4,  2,  4,  2,  4,  27,  2,  27,  4,  27,  2,  2,  4,
    2,  4,  2,  4,  2,  4,  2,  4,  27,  2,  27,  4,  2,  4,  2,  4,
    2,  4,  2,  4,  2, 11, 11, 11,

    // jynks
    11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 22, 22,
    7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
    7,  7,  7,  7,  7,  7,  7,  7, 7,  7,  7,  7,  7,  7,  7,  11,
    23, 11, 23, 11,
    7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
    7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,
    23, 11, 11, 11, 11, 11, 11, 11,

    // tss
    11, 11, 11, 11, 11, 11, 11, 11, 9,  9,  9,  9,  9,  9,  9,  9,
    11, 11, 11, 11, 11, 11, 11, 11, 8,  8,  8,  8,  8,  8,  8,  8,
    8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
    11, 11, 11, 11,
    8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
    8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,  8,
    11, 11, 11, 11, 11, 11, 11, 11,
};

IVARIABLE int patternpos = -1;

IVARIABLE sample_t tmp[S_NUM_DELAYS];

IVARIABLE DelayLine delays[S_NUM_DELAYS] = {
    // master lim L (0)
    {
      S_TICKLEN,
      0,
      0.0, 0.0,
      //{0},
    },

    // master lim R (1)
    {
      S_TICKLEN,
      0,
      0.0, 0.0,
      //{0},
    },
      

    // guitar 1 (2-3)
    { 
      S_TICKLEN,
      0,
      0.7, 0.3 - S_FADE1,
      //{0},
    },

    { 
      S_TICKLEN,
      0,
      0.6, 0.4 - S_FADE1,
      //{0},
    },

    // dnb compressor 4
    { 
      S_TICKLEN,
      0,
      0, 0.0,
      //{0},
    },

    // bass (5)
    {
      S_TICKLEN,
      0,
      0.7, 0.3 - S_FADE1 * 40,
      //{0},
    },
    
    // guitar 1 dist (6)
    {
      1000,
      0,
      -0.15, 0.0,
      //{0},
    },

    // bd (7)
    {
      S_TICKLEN,
      0,
      0.9, 0.1,
      //{0},
    },

    // plim (8)
    {
      S_TICKLEN,
      0,
      0.97, 0.03 - S_FADE1 * 100,
      //{0},
    },

    { // snare (9 )
      S_TICKLEN,
      0,
      0.80,-0.10,
      //{0},
    },

    // master delay L
    {
      13000,
      0,
      0.3, 0.5,
      //{0},
    },

    // master delay R
    {
      10000,
      0,
      0.4, 0.4,
      //{0},
    },
};

// master limiter input gainz
#define M 0.66
//#define M 0.0

// the main mixer matrix
IVARIABLE sample_t mixer[S_NUM_DELAYS*S_NUM_DELAYS] = {
    // master limiter (0, 1)
    0, 0, 0, 0,  M*0.6 ,0, 0, 0,
    M*0.4, M*0.25, M*0.6, 0,

    0, 0, 0, M*0.1,  M*0.6, 0, 0, 0,
    0, M*0.2,  0.0, M*0.6,

    // guitar 1 (2, 3)
    0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0,

    0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0,

    // dnb comp. 4
    0, 0, 0, 0,  0, 2.4, 0, 1.3,
    0, 0, 0, 0,

    // bass (5)
    0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0,

    // guitar 1 dist (6)
    0, 0, 748, 748,  0, 0, 0, 0,
    0, 0, 0, 0,

    // bd + comp (7)
    0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0,

    // plim (8)
    0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0, 

    // kohina
    0, 0, 0, 0,  0, 0, 0, 0,
    0, 0, 0, 0, 
    
    // master delay
    0,0,0,0,  0,0.1,0.43,0,
     0.65,/*0.5,*/
     0.1,0, 0, 

    0,0,0,0, 0 ,0.1,0.48,0.0,
     0.65,/*0.4,*/
    0.1,0,0, 

    /* // diu */
    /* 0, 0, 0, 0,  0, 0, 0, 0, */
    /* 0, 0, 0, 0,  0, */
};
#endif // _SYN_DEFS_H_
