; ELF Header

elf_header:				; e_ident
db 0x7f , "ELF"				;  MAG[0-3]
db EHDR_CLASS32				;  EI_CLASS
db EHDR_DATA2LSB			;  EI_DATA
db EHDR_VCURRENT			;  EI_VERSION
db EHDR_NONE				;  EI_OSABI
db EHDR_OSABI				;  EI_ABIVERSION
times 7 db 0x00				;  EI_PAD
dw EHDR_EXEC				; e_type
dw EHDR_386				; e_machine
dd EHDR_CURRENT				; e_version
dd _start				; e_entry
dd program_header_table-SYS_ORIGIN	; e_phoff
dd 0x00000000				; e_shoff
dd 0x00000000				; e_flags
dw elf_header_size			; e_ehsize
dw program_header_table_size		; e_phentsize
dw 0x0003				; e_phnum
dw 0x0000				; e_shentsize
dw 0x0000				; e_shnum
dw 0x0000				; e_shstrndx
elf_header_size equ $ - elf_header

; Program Header Table
program_header_table: 
	; Interp
	dd PHDR_INTERP				; p_type
	dd interp-SYS_ORIGIN			; p_offset
	dd interp				; p_vaddr
	dd 0x00000000				; p_addr
	dd interp_size				; p_filesize
	dd interp_size				; p_memsz
	dd PHDR_FLAGS_RO			; p_flags
	dd 0x00000000				; p_align 
program_header_table_size equ $ - program_header_table

	; Load
	dd PHDR_LOAD				; p_type
	dd 0x00000000				; p_offset
	dd SYS_ORIGIN				; p_vaddr
	dd 0x00000000				; p_addr
	dd SYS_FILESIZE				; p_filesize
	dd SYS_MEMSIZE				; p_memsz
	dd PHDR_FLAGS_RWX			; p_flags
	dd 0x00000100				; p_align
	
	; Dynamic
	dd PHDR_DYNAMIC				; p_type
	dd dynamic-SYS_ORIGIN			; p_offset
	dd dynamic				; p_vaddr
	dd 0x00000000				; p_addr
	dd dynamic_size				; p_filesize
	dd dynamic_size				; p_memsz
	dd PHDR_FLAGS_RO			; p_flags
	dd 0x00000004				; p_align

; Interp data
interp:
	db "/lib/ld-linux.so.2" , 0x00
interp_size equ $ - interp

; Dynamic data
strtab:
	db 0x00
libsdl: db "libSDL-1.2.so.0" , 0x00
libgl:	db "libGL.so.1" , 0x00

; Dynamic strucutre
dynamic:
		dd DT_NEEDED				; d_tag - libSDL
		dd libsdl - strtab			; d_un
		dd DT_NEEDED				; d_tag - libGL
		dd libgl - strtab			; d_un
		dd DT_STRTAB				; d_tag - strtab
		dd strtab				; d_un
		dd DT_SYMTAB				; d_tag - symtab (unused but required otherwise it segfaults)
		dd 0x00000000				; d_un
		dd DT_DEBUG				; d_taf - debug
r_debug_ptr:	dd 0x00000000				; d_un
		dd DT_NULL				; d_tag NULL (end of dynamic)
dynamic_size equ $ - dynamic
