package com.tumbleweed.riseshine;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Calendar;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.PowerManager;
import android.os.SystemClock;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;


public class SatanAlarm extends Activity 
{
	Intent intent;
	RiseShineHelper rsHelper;
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) 
    {
    	super.onCreate(savedInstanceState);
    	setContentView(R.layout.alarm);

    	PowerManager pm = (PowerManager) getSystemService(Context.POWER_SERVICE);
    	pm.userActivity(SystemClock.uptimeMillis(), false);

    	//allocate and init the helper class.
    	rsHelper = new RiseShineHelper();
    	rsHelper.init(this);

    	
    	intent = new Intent("com.google.zxing.client.android.SCAN");
    	intent.putExtra("SCAN_MODE", "QR_CODE_MODE");

    	mScanCode = (Button)findViewById(R.id.Button01);

    	// add a click listener to the button
    	mScanCode.setOnClickListener(new View.OnClickListener() 
    	{
    		public void onClick(View v) 
    		{
    			startActivityForResult(intent, 0);
    		}
    	});

    	//start the bar code scanner.
    	startActivityForResult(intent, 0);

    	text = (TextView) findViewById(R.id.TextView01);

    	//MAKE LOTS OF NOOOOIIISE!! :)
    	mp = MediaPlayer.create(this, R.raw.awakefromyourasleep);
    	AudioManager am =  (AudioManager) getSystemService(AUDIO_SERVICE); 
    	am.setStreamVolume(AudioManager.STREAM_MUSIC,am.getStreamMaxVolume(AudioManager.STREAM_MUSIC),0);
    	mp.setLooping(true);
    	mp.start();
        
    }
        
        public void onActivityResult(int requestCode, int resultCode, Intent intent) 
        {
        	if (requestCode == 0) {
        		if (resultCode == RESULT_OK) {
        			String contents = intent.getStringExtra("SCAN_RESULT");
        			String format = intent.getStringExtra("SCAN_RESULT_FORMAT");
        			// Handle successful scan

        			text.setText(contents);


        			rsHelper.codeScanned(this,contents,true);
        			
        			if(rsHelper.getIfScannedWrongSeq())
        			{
        				//someone scanned the wrong bar code.
        				//we want to simulate an exit withoutscan and strictMode.
        				exitWithoutScan = true;
        				strictModeSimulated = true;

        				//should toast about it.
        			}
        			else
        			{
        				mp.stop(); 
        				exitWithoutScan = false;
        			}

        			if(rsHelper.getIfLastSeqScanned())
        			{
        				rsHelper.administerDigitalChocolate(this);
        				
        			}
        			
        			//kill this program.
    				this.finish();
        			

        		} 
        		else if (resultCode == RESULT_CANCELED) 
        		{
        			// Handle cancel
        		}
        	}
        }


        @Override
        public void onPause() 
        {
        	super.onPause();

        }//*/
        
        @Override
        public void onResume() 
        {
        	super.onResume();
        	
        }//*/
        
        @Override
        public void onDestroy() 
        {
        	super.onDestroy();
        	if(exitWithoutScan)
        	{
        		if(mp!=null)
        			mp.stop();
        		
        		if(strictModeSimulated || rsHelper.isInStrictMode())
        		{
        			//relaunch alarm.
        			Calendar alarmTime = Calendar.getInstance();
        			rsHelper.issueAlarm(alarmTime.getTimeInMillis(),this);
        		}
        		else
        		{
        			rsHelper.onAlarmCancelOrExit(this);
        		}
        	}
        	//release wakelock if needed.
        	if(wl!=null)
        		wl.release();
        	wl = null;
        }//*/
        
        
        boolean exitWithoutScan = true;
      
        Button mScanCode;
        TextView text;
        MediaPlayer mp;
        
        boolean strictModeSimulated = false;
       
        public static PowerManager.WakeLock wl=null;


}