#version 120
uniform sampler2D normal_depth;
uniform vec2 InvViewport;

#include <deferred_include.frag>
#include <shadow_include.frag>


void main()
{
	vec2 uv_pos = (gl_FragCoord.xy + vec2(0.5)) * InvViewport;
	vec4 nd = texture2D(normal_depth, uv_pos);
	vec3 pos = calc_position(uv_pos, nd.w);

	vec4 first_lpos = gl_TextureMatrix[0] * vec4(pos, 1.0);
	vec4 second_lpos = gl_TextureMatrix[1] * vec4(pos, 1.0);

	float first_shadow_term = 1.0;
	if ( first_lpos.z >= 0.0 )
	{
		first_lpos /= first_lpos.w;
		first_shadow_term = vsm_shadow_first(first_lpos);
	}

	float second_shadow_term = 1.0;
	if ( second_lpos.z >= 0.0 )
	{
		second_lpos /= second_lpos.w;
		second_shadow_term = vsm_shadow_second(second_lpos);
	}

	float shadow_term = clamp(first_shadow_term + second_shadow_term, 0.0, 1.0);

	gl_FragColor = vec4(1.0 - (1.0 - shadow_term)*0.5);
}
