
//
// http://en.wikipedia.org/wiki/Fresnel_equations
//
void fresnel_refract(in vec3 incomming, in vec3 normal, in float index_external, in float index_internal, out vec3 reflection, out vec3 refraction, out float reflectance, out float transmittance)
{
	float eta = index_external / index_internal;
	float cos_theta1 = dot(incomming, normal);
	float cos_theta2 = sqrt(1.0 - eta*eta*(1.0 - cos_theta1*cos_theta1));
	
	reflection = incomming - 2.0*cos_theta1*normal;
	refraction = eta*incomming + (cos_theta2 - eta*cos_theta1) * normal;

	float rs = (index_external*cos_theta1 - index_internal*cos_theta2 ) / (index_external*cos_theta1 + index_internal*cos_theta2);
	float rp = (index_internal*cos_theta1 - index_external*cos_theta2 ) / (index_internal*cos_theta1 + index_external*cos_theta2);

	reflectance = (rs*rs + rp*rp) / 2.0;
	transmittance = ((1.0 - rs) * (1.0 - rs) + (1.0 - rp) * (1.0 - rp)) / 2.0;
}
