#version 120
#extension GL_EXT_geometry_shader4 : enable

varying in vec3 gs_params[]; // radius, energy, 1/mass

varying out vec3 ec_pos;
varying out vec2 pos_zw;

#define EMIT_VERTEX(VTX, EYE) \
	ec_pos = EYE; \
	pos_zw = VTX.zw; \
	gl_Position = VTX; \
	EmitVertex()

#define MAKE_QUAD(A, B, C, D) \
	EMIT_VERTEX(vertices[A], ec_eye[A]); \
	EMIT_VERTEX(vertices[B], ec_eye[B]); \
	EMIT_VERTEX(vertices[D], ec_eye[D]); \
	EMIT_VERTEX(vertices[C], ec_eye[C]); \
	EndPrimitive()

vec3 cube_vertices[8] = vec3[](
    vec3( 1.0,  1.0, -1.0),
    vec3(-1.0,  1.0, -1.0),
    vec3(-1.0, -1.0, -1.0),
    vec3( 1.0, -1.0, -1.0),
    vec3( 1.0,  1.0,  1.0),
    vec3(-1.0,  1.0,  1.0),
    vec3(-1.0, -1.0,  1.0),
    vec3( 1.0, -1.0,  1.0)
);

void main()
{
	if ( gs_params[0].x <= 0.0 ) return;

	vec3 center = gl_PositionIn[0].xyz;
	float radius = gs_params[0].x;

	vec4 vertices[8];
	vec3 ec_eye[8];
	for (int i=0; i < 8; i++)
	{
		vec4 pos = vec4(center + cube_vertices[i]*radius, 1.0);
		ec_eye[i] = vec3(gl_ModelViewMatrix * pos);
		vertices[i] = gl_ModelViewProjectionMatrix * pos;
	}

	MAKE_QUAD(3,2,1,0);
	MAKE_QUAD(4,5,6,7);
	MAKE_QUAD(6,5,1,2);
	MAKE_QUAD(7,3,0,4);
	MAKE_QUAD(5,4,0,1);
	MAKE_QUAD(7,6,2,3);
}
