#version 120

uniform sampler2D light_accumulation;

uniform vec2 Direction;
uniform vec2 TexelSize;
uniform vec4 Weights;
uniform float B;

varying vec2 uv;

void main()
{
#define LOD_LEVEL 0.0

	vec2 sc = Direction*TexelSize*B;

	vec4 color = texture2DLod(light_accumulation, uv, LOD_LEVEL)*Weights.x;

	color += texture2DLod(light_accumulation, uv + sc, LOD_LEVEL)*Weights.y;
	color += texture2DLod(light_accumulation, uv - sc, LOD_LEVEL)*Weights.y;

	sc += sc;
	color += texture2DLod(light_accumulation, uv + sc, LOD_LEVEL)*Weights.z;
	color += texture2DLod(light_accumulation, uv - sc, LOD_LEVEL)*Weights.z;

	sc += sc;
	color += texture2DLod(light_accumulation, uv + sc, LOD_LEVEL)*Weights.w;
	color += texture2DLod(light_accumulation, uv - sc, LOD_LEVEL)*Weights.w;

	//gl_FragColor = vec4(color.rgb*color.a, 1.0);
	gl_FragColor = vec4(color.rgb, 1.0);
	//gl_FragColor = vec4(color.aaa, 1.0);
}
