#version 120
uniform sampler2D normal_depth;
uniform sampler2D light_accumulation;

uniform vec2 gi_radius;
uniform vec2 ao_radius;

varying vec2 texCoord;

#define NUM_SAMPLES 8

#include <deferred_include.frag>


float conv_depth(in float d)
{
	return d*0.5 + 0.5;
}

void main()
{
	// light_accumulation mipmap level to sample from
#define LOD_LEVEL 1.0

	const float PI = 3.1415926;
	const float color_threshold = 0.3;
	const float depth_threshold = 0.0;

	vec4 nd = texture2D(normal_depth, texCoord);

	int samples = int( floor( (float(NUM_SAMPLES) / (nd.w*0.5 + 1.0)) + 0.5) );
	if ( samples > NUM_SAMPLES ) samples = NUM_SAMPLES;
	
	int hf = samples/2;

	float rnd = rand(texCoord);
	float z_div = (1.0 + (nd.w*0.5 + 0.5))*float(hf);
	vec2 gi_mult = clamp(gi_radius/z_div, -gi_radius, gi_radius) * rnd;
	vec2 ao_mult = clamp(ao_radius/z_div, -ao_radius, ao_radius) * rnd;

	float ao_sum = 0.0;
	vec3 gi_color = vec3(0.0);

	for(int i=-hf; i < hf; i++)
	{
		for(int j=-hf; j < hf; j++)
		{
			if ( i != 0 || j != 0 )
			{
				vec2 coords = vec2(float(i), float(j)) * gi_mult;
				vec2 coords2 = vec2(float(i), float(j)) * ao_mult;
				vec2 uv = texCoord + coords;
				vec2 uv2 = texCoord + coords2;

				vec4 nd2 = texture2D(normal_depth, uv);
				vec4 nd2g = texture2D(normal_depth, uv2);				
				vec3 dc = texture2DLod(light_accumulation, uv, LOD_LEVEL).xyz;

				float depth_coherence = dot(-coords2, nd2g.xy);
				if ( depth_coherence > depth_threshold )
				{
					//vec3 dist2 = vec3(coords2, (conv_depth(nd.w) - conv_depth(nd2g.w)));
					vec3 dist2 = vec3(coords2, nd.w - nd2g.w);
					float pformfactor = 0.5*((1.0 - dot(nd.xyz, nd2g.xyz))) / (PI*pow(length(dist2*2.0), 2.0) + 0.5);
					ao_sum += clamp(pformfactor*0.2, 0.0, 1.0);
				}

				if ( length(dc) > color_threshold )
				{
					depth_coherence = dot(-coords, normalize(nd2.xy));
					if ( depth_coherence > depth_threshold )
					{
						//vec3 dist = vec3(coords, (conv_depth(nd.w) - conv_depth(nd2.w)));
						vec3 dist = vec3(coords, nd.w - nd2.w);
						float pformfactor = ((1.0 - dot(nd.xyz,nd2.xyz))) / (PI*pow(length(dist*2.0), 2.0) + 0.5);
						gi_color += dc*clamp(pformfactor, 0.0, 1.0);
					}
				}
			}
		}
	}

	vec3 bleeding = (gi_color / float(samples))*(1.0/4.0);
	float occlusion = 1.0 - (ao_sum / float(samples));
	//bleeding.b = float(samples) / float(NUM_SAMPLES);
	gl_FragColor = vec4(bleeding, occlusion);
}
