#version 120

//varying in vec3 gs_spot_dir[];
varying in vec3 gs_spot_params[]; // cone_angle, cone_cutoff_angle, intensity
varying in vec3 gs_spot_color[]; // x,y,z,length

varying out vec3 spot_pos;
varying out vec3 spot_dir;
varying out vec3 spot_params;
varying out vec3 color;

#define EMIT(VTX) \
	spot_pos = pos; \
	spot_dir = dir; \
	spot_params = gs_spot_params; \
	color = gs_spot_color; \
	gl_Position = VTX; \
	EmitVertex()

void main()
{
	vec3 pos = gl_PositionIn[0].xyz;
	spot_params = gs_spot_params;
	color = gs_spot_color;
	vec3 dir = normalize( vec3(gl_ModelviewMatrix * vec4(0.0, 0.0, 1.0, 0.0)) );

	EMIT(vec4(1.0, 1.0, 1.0, 1.0));
	EMIT(vec4(-1.0, 1.0, 1.0, 1.0));
	EMIT(vec4(-1.0, -1.0, 1.0, 1.0));
	EMIT(vec4(1.0, -1.0, 1.0, 1.0));
	EndPrimitive();
}
