#version 120
uniform sampler2D diffuse_specular;
uniform sampler2D normal_depth;
uniform vec2 viewport;

varying vec4 light_pos;
varying vec3 color;

#include <deferred_include.frag>

void main()
{
	const float SPECULAR_POWER = 8.0;

	vec2 uv_pos = gl_FragCoord.xy * viewport;
	vec4 ds = texture2D(diffuse_specular, uv_pos);
	vec4 nd = texture2D(normal_depth, uv_pos);

	vec3 pos = calc_position(uv_pos, nd.w);

	vec3 light_dir = light_pos.xyz - pos;
	float len = length(light_dir);
	if ( len > light_pos.w ) discard;

	light_dir = normalize( light_dir );

	vec3 normal = MAKE_NORMAL(nd.xyz);
	float NdotL = dot(normal, light_dir);
	if ( NdotL <= 0.0 ) discard;

	float atten = 1.0 - (len / light_pos.w);
	vec3 half_vector = normalize(reflect(normalize(pos), light_dir));
	float NdotHV = max(dot(normal, half_vector), 0.0)*NdotL;

	vec3 lit = color*ds.rgb*NdotL + color*ds.a*pow(NdotHV, SPECULAR_POWER);
	gl_FragColor = vec4(lit*atten, 1.0);
}
