#version 120
attribute vec3 POSITION;
attribute vec3 NORMAL;
attribute vec2 TEXCOORD;

uniform vec4 Bulge; // x,y,z,r

varying vec2 pos_zw;
varying vec3 normal;
varying vec2 uv;
varying vec3 color;

void main()
{
	vec3 pos = POSITION;

	vec3 c = vec3(1.0);

	float len = length(pos - Bulge.xyz);
	if ( len < Bulge.w )
	{
		float att = smoothstep(0.0, 1.0, 1.0 - (len / Bulge.w));
		pos += NORMAL*att*0.1;
		c = mix(vec3(1.0), vec3(239.0/255.0, 108.0/255.0, 18.0/255.0), att);
	}

	uv = TEXCOORD;
	color = c;

	normal = gl_NormalMatrix * NORMAL; //vec3(gl_ModelViewMatrix * vec4(NORMAL, 0.0));

	vec4 proj_pos = gl_ModelViewProjectionMatrix * vec4(pos, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
