#version 120
#extension GL_EXT_geometry_shader4 : enable

uniform vec4 Extrude; // inset_a_factor, inset_b_factor, extrude_factor, spike_factor

varying in vec3 gs_normal[];
varying in vec2 gs_uv[];

varying out vec3 ec_pos;
varying out vec2 pos_zw;
varying out vec2 uv;

#define EMIT_VERTEX(VTX, EYE, UV) \
	uv = UV; \
	ec_pos = EYE; \
	pos_zw = VTX.zw; \
	gl_Position = VTX; \
	EmitVertex()

#define EMIT_QUAD(A,B,C,D) \
	EMIT_VERTEX(vertices[A], eyespace[A], uvs[A]); \
	EMIT_VERTEX(vertices[B], eyespace[B], uvs[B]); \
	EMIT_VERTEX(vertices[C], eyespace[C], uvs[C]); \
	EMIT_VERTEX(vertices[D], eyespace[D], uvs[D]); \
	EndPrimitive()

#define EMIT_TRI(A, B, C) \
	EMIT_VERTEX(vertices[A], eyespace[A], uvs[A]); \
	EMIT_VERTEX(vertices[B], eyespace[B], uvs[B]); \
	EMIT_VERTEX(vertices[C], eyespace[C], uvs[C]); \
	EndPrimitive()

float rand(in vec2 co)
{
        return 0.5 + (fract(sin(dot(co.xy, vec2(12.9898, 78.233))) * 43758.5453))*0.5;
        //return abs(fract(sin(dot(co.xy, vec2(12.9898, 78.233)))* 43758.5453));
        //return fract( dot(co.xy+co.yx,vec2(123.456,789.123)) );
}


void main()
{
	if ( rand(gl_PositionIn[0].xy) > 0.9 && Extrude.z != 0.0 )
	{
		vec3 center = (gl_PositionIn[0].xyz + gl_PositionIn[1].xyz + gl_PositionIn[2].xyz) / 3.0;
		vec3 direction = normalize(gs_normal[0] + gs_normal[1] + gs_normal[2]);
		vec2 cuv = (gs_uv[0] + gs_uv[1] + gs_uv[2])/3.0;

		vec3 elevate = direction*Extrude.z;

		vec3 eyespace[10];
		vec4 vertices[10];
		vec2 uvs[10];
		for (int i=0; i < 3; i++)
		{
			eyespace[i] = vec3(gl_ModelViewMatrix * gl_PositionIn[i]);
			vertices[i] = gl_ModelViewProjectionMatrix * gl_PositionIn[i];
			uvs[i] = gs_uv[i];

			vec4 pos = vec4(gl_PositionIn[i].xyz + (center - gl_PositionIn[i].xyz)*Extrude.x, 1.0);
			eyespace[i+3] = vec3(gl_ModelViewMatrix * pos);
			vertices[i+3] = gl_ModelViewProjectionMatrix * pos;
			uvs[i+3] = gs_uv[i] + (cuv - gs_uv[i])*Extrude.x;

			pos = vec4(gl_PositionIn[i].xyz + elevate + (center - gl_PositionIn[i].xyz)*Extrude.y, 1.0);
			eyespace[i+6] = vec3(gl_ModelViewMatrix * pos);
			vertices[i+6] = gl_ModelViewProjectionMatrix * pos;
			uvs[i+6] = gs_uv[i] + (cuv - gs_uv[i])*Extrude.y;
		}

		EMIT_QUAD(0, 1, 3, 4);
		EMIT_QUAD(1, 2, 4, 5);
		EMIT_QUAD(2, 0, 5, 3);

		EMIT_QUAD(3, 4, 6, 7);
		EMIT_QUAD(4, 5, 7, 8);
		EMIT_QUAD(5, 3, 8, 6);

		if ( /*rand(center.xy) > 0.9 &&*/ Extrude.w != 0.0 )
		{
			// spike
			float spike_factor = Extrude.z + Extrude.w;
			vec4 pos = vec4(center + direction*spike_factor, 1.0);
			eyespace[9] = vec3(gl_ModelViewMatrix * pos);
			vertices[9] = gl_ModelViewProjectionMatrix * pos;
			uvs[9] = cuv;

			EMIT_TRI(6, 7, 9);
			EMIT_TRI(7, 8, 9);
			EMIT_TRI(8, 6, 9);
		}
		else
		{
			EMIT_TRI(6, 7, 8);
		}
	}
	else
	{
		for (int i=0; i < 3; i++)
		{
			uv = gs_uv[i];
			ec_pos = vec3(gl_ModelViewMatrix * gl_PositionIn[i]);
			gl_Position = gl_ModelViewProjectionMatrix * gl_PositionIn[i];
			pos_zw = gl_Position.zw;
			EmitVertex();
		}
		EndPrimitive();
	}
}
