#version 120
//#extension ARB_draw_buffers : enable

uniform sampler2D diffuse;
uniform sampler2D specular;
uniform float     Length;

varying vec2 pos_zw;
varying vec3 normal;
varying vec2 uv;

#include <geometry_include.frag>

void main()
{
	if ( uv.y > Length ) discard;

	WRITE_DIFFUSE( texture2D(diffuse, uv).rgb );
	WRITE_SPECULAR( texture2D(specular, uv).r );

	float front = gl_FrontFacing ? 1.0 : -1.0;
	WRITE_NORMAL( normalize(normal*front) );
	WRITE_DEPTH( pos_zw.x/pos_zw.y );
}
