#version 120
// #extension ARB_draw_buffers : enable

uniform sampler2D diffuse;
uniform sampler2D specular;

varying vec2 pos_zw;
varying vec3 ec_pos;
//varying vec2 uv;

#include <geometry_include.frag>

void main()
{
	vec3 normal = normalize(cross(dFdx(ec_pos), dFdy(ec_pos)));

	float dx = dot(vec3(1.0, 0.0, 0.0), normal);
	float dy = dot(vec3(0.0, 1.0, 0.0), normal);
	float dz = dot(vec3(0.0, 0.0, 1.0), normal);
	
	vec2 uv = (ec_pos.yz*dx + ec_pos.xz*dy + ec_pos.xy*dz) * 5.0;

	WRITE_DIFFUSE( texture2D(diffuse, uv).rgb );
	WRITE_SPECULAR( texture2D(specular, uv).r );

	WRITE_NORMAL( normal );
	WRITE_DEPTH( pos_zw.x/pos_zw.y );
}
