#version 120
#extension GL_EXT_geometry_shader4 : enable

uniform vec4 Explode; // center.xyz, amount
uniform vec4 Twist; // center.xyz, radius

varying in vec3 gs_normal[];
varying in vec2 gs_uv[];

varying out vec2 pos_zw;
varying out vec3 normal;
varying out vec2 uv;

#include <deforms_include.vert>
#include <matrix_include.vert>

#define EMIT_VERTEX(VTX, NORM, UV) \
	uv = UV; \
	normal = gl_NormalMatrix * NORM; \
	proj_pos = gl_ModelViewProjectionMatrix * vec4(VTX, 1.0); \
	pos_zw = proj_pos.zw; \
	gl_Position = proj_pos; \
	EmitVertex()

void main()
{
	//vec3 center = twist_y( (gl_PositionIn[0].xyz + gl_PositionIn[1].xyz + gl_PositionIn[2].xyz) / 3.0 );
	//vec3 center = twist_y( (gl_PositionIn[0].xyz + gl_PositionIn[1].xyz + gl_PositionIn[2].xyz) / 3.0, Twist.xyz, Twist.w, Explode.w );
	vec3 center = (gl_PositionIn[0].xyz + gl_PositionIn[1].xyz + gl_PositionIn[2].xyz) / 3.0;
	vec3 offset = normalize(center - Explode.xyz);

	mat3 mr;
	rotate_around_axis(normalize(gs_normal[1]-offset.zxy*0.5), Explode.w*6.0, mr);
	//rotate_around_axis(offset, Explode.w*6.0, mr);

	offset *= Explode.w;

	vec4 proj_pos;
	for (int i=0; i < 3; i++)
	{
		vec3 v = mr*(gl_PositionIn[i].xyz - center) + center + offset;
		vec3 n = mr * gs_normal[i];
		EMIT_VERTEX(v, n, gs_uv[i]);
	}
	EndPrimitive();
}
