#version 120
#extension GL_EXT_geometry_shader4 : enable

uniform vec3 XAxis;
uniform vec3 YAxis;
uniform vec4 NearPlane;

varying in vec3 gs_light_params[]; // radius
varying in vec3 gs_light_color[];

varying out vec4 light_pos;
varying out vec3 color;

#define EMIT_VERTEX(VTX) \
	light_pos = lpos; \
	color = gs_light_color[0]; \
	gl_Position = vec4(VTX); \
	EmitVertex()

void main()
{
	vec3 wpos = gl_PositionIn[0].xyz;
	float radius = gs_light_params[0].x*1.5;
	vec4 lpos = vec4(wpos, gs_light_params[0].x);

	vec4 corners[4];
	corners[0] = gl_ProjectionMatrix * vec4(wpos + (XAxis + YAxis)*radius, 1.0);
	corners[1] = gl_ProjectionMatrix * vec4(wpos + (YAxis - XAxis)*radius, 1.0);
	corners[2] = gl_ProjectionMatrix * vec4(wpos + (-XAxis - YAxis)*radius, 1.0);
	corners[3] = gl_ProjectionMatrix * vec4(wpos + (XAxis - YAxis)*radius, 1.0);

	for (int i=0; i < 4; i++)
	{
		corners[i] /= abs(corners[i].w);
		corners[i].zw = vec2(1.0);
		corners[i].xy = clamp(corners[i].xy, -1.0, 1.0);
	}

	EMIT_VERTEX(corners[0]);
	EMIT_VERTEX(corners[1]);
	EMIT_VERTEX(corners[3]);
	EMIT_VERTEX(corners[2]);
	EndPrimitive();
}
