#version 120
varying vec4 gs_light_plane;
varying vec3 gs_light_coeff; // size, length, intensity

void main()
{
	vec3 p0 = vec3(gl_ModelViewMatrix * gl_Vertex);
	vec3 p1 = vec3(gl_ModelViewMatrix * vec4(gl_MultiTexCoord1.xyz, 1.0));
	vec3 dir = normalize(p1 - p0);
	gs_light_plane.xyz = dir;
	gs_light_plane.w = -dot(dir, p0);
	gs_light_coeff = gl_MultiTexCoord2.xyz;
	gl_Position = gl_Vertex;
}

