#version 120
uniform sampler2D diffuse_specular;
uniform sampler2D normal_depth;
uniform vec2      viewport;

varying vec4 light_plane;
varying vec3 light_pos;
varying vec3 light_coeff; // size, length, intensity

#include <deferred_include.frag>


float point_plane_intersection( in vec3 pos )
{
	float dist = dot(light_plane.xyz, pos) + light_plane.w;
	if ( dist < 0.0 )
	{
		return 0.0;
	}
	else
	{
		vec3 isect = pos - light_plane.xyz*dist;
		vec3 pn = light_pos - isect;
		float s = min( length( light_pos - isect ), light_coeff.x ) / light_coeff.x;
		float l = min( dist, light_coeff.y ) / light_coeff.y;
		return (1.0 - pow(s, 8.0)) * (1.0 - pow(l, 8.0));
	}
}

void main()
{
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	vec4 ds = texture2D(diffuse_specular, uv_pos);
	vec4 nd = texture2D(normal_depth, uv_pos);

	vec3 pos = calc_position(uv_pos, nd.w);

	float atten = point_plane_intersection(pos);
	vec3 normal = normalize(nd.xyz);
	vec3 light_dir = normalize(light_pos.xyz - pos);
	float ndotl = max(dot(normal, light_dir), 0.0);
	if ( ndotl <= 0.0 ) discard;

	vec4 final_color = vec4( 0.0 );
	vec3 half_vector = normalize(reflect(pos, light_plane.xyz));
	float ndothv = max(dot(normal, half_vector), 0.0);
	final_color = vec4( (ds.xyz*ndotl + vec3(nd.w)*pow(ndothv, ds.w))*atten, 1.0 );

	gl_FragColor = final_color * light_coeff.z;
}
