#version 120
uniform sampler2D normal_depth;
uniform sampler2D particle;
//uniform sampler2D noise;
uniform vec2 viewport;
uniform float Smoothness;

varying vec3 wpos;
varying vec2 uv;

#include <deferred_include.frag>

/*
float pnoise(in vec3 pos)
{
	float n = texture2D(noise, pos.xy*20.0).x;//*2.0 - 1.0;
	return max(0.0, n); //0.75 + n*n*n*0.25;
}
*/

void main()
{
	vec4 pcolor = texture2D(particle, uv);
	
	vec2 uv_pos = gl_FragCoord.xy * viewport;
	float d = texture2D(normal_depth, uv_pos).w;
	vec3 pos = calc_position(uv_pos, d);
	
	if ( pos.z > wpos.z ) discard;

	float alpha = clamp((wpos.z - pos.z)*Smoothness, 0.0, 1.0);
	gl_FragColor = pcolor*alpha;
}
