#version 120
attribute vec3 POSITION;
attribute vec3 NORMAL;

varying vec2 pos_zw;
varying vec3 normal;
varying vec3 cube_uv;
varying vec2 uv;

void main()
{
	vec3 axis[3] = vec3[3](
		vec3(1.0, 0.0, 0.0),
		vec3(0.0, 1.0, 0.0),
		vec3(0.0, 0.0, 1.0)
	);
	
	vec3 n = normalize(NORMAL);
	float dx = dot(axis[0], n);
	float dy = dot(axis[1], n);
	float dz = dot(axis[2], n);
	
	cube_uv = normalize(POSITION);
	uv = (POSITION.yz*dx + POSITION.xz*dy + POSITION.xy*dz) * 5.0;

	normal = vec3(gl_ModelViewMatrix * vec4(NORMAL, 0.0));

	vec4 proj_pos = gl_ModelViewProjectionMatrix * vec4(POSITION, 1.0);
	pos_zw = proj_pos.zw;
	gl_Position = proj_pos;
}
