#include version.txt

varying vec4 ambient;
varying vec4 ambient2;
varying vec4 diffuse;
varying vec4 diffuse2;

varying vec3 normal;
varying vec3 lightDir;
varying vec3 lightDir2;
varying vec3 halfVector;
varying vec3 halfVector2;
	
void main() {
	vec3 n,halfV;
	float NdotL,NdotHV;
    vec4 final_col;
		
	vec4 color = ambient;
	vec4 color2 = ambient2;
		
	n = normalize(normal);
		
	NdotL = max(dot(n, lightDir), 0.0);

	if (NdotL > 0.0) {
		color += diffuse * NdotL;
		halfV = normalize(halfVector);
		NdotHV = max(dot(n,halfV),0.0);
		color += vec4(1.0, 1.0, 1.0, 1.0) * 
				 vec4(1.0, 1.0, 1.0, 1.0) * 
				 pow(NdotHV, 100.0);
	}

	NdotL = max(dot(n, lightDir2), 0.0);

	if (NdotL > 0.0) {
		color2 += diffuse2 * NdotL;
		halfV = normalize(halfVector2);
		NdotHV = max(dot(n,halfV),0.0);
		color2 += vec4(1.0, 1.0, 1.0, 1.0) * 
				  vec4(1.0, 0.0, 0.0, 1.0) * 
				  pow(NdotHV, 100.0);

	}

    float z = gl_FragCoord.z;
	
	final_col = vec4(color + color2);
	gl_FragColor = mix(vec4(final_col.rgb, 1.0), vec4(0.0, 0.0, 0.0, 1.0), (z * 2.25) - 1.125);	
}

