#include version.txt

uniform sampler2D robot;
uniform sampler2D intensitymap;
varying vec2 Texcoord;
uniform vec2 step;

void main( void )
{
    vec4 intensity = texture2D(intensitymap, Texcoord);
    vec4 color = texture2D(robot, Texcoord*step);
    float col = color.r * (intensity.r * 4.0); 
    float finalColor = col * color.a;
    gl_FragColor = vec4(finalColor, 0.0, 0.0, color.a);
}
