#version 120
uniform sampler2D tex_diffuse;
uniform sampler2D tex_normal;
uniform sampler2D tex_depth;

uniform vec3 fov_modifier;
uniform vec3 light_dir;

/**
 * Decodes signed normals from their unsigned storage format.
 */
vec3 wrangleNormal(in vec3 sample){
    return vec3( (sample.x*2.0-1.0)
               , (sample.y*2.0-1.0)
               , (sample.z*2.0-1.0));
}

void main(){
    vec2 texCoord = gl_TexCoord[0].xy;

    vec3 eyeVec = vec3(texCoord * 2.0 - vec2(1,1), -1.0) * fov_modifier;

    vec4 diffuse = texture2D(tex_diffuse, texCoord);
    vec3 ns = texture2D(tex_normal, texCoord).xyz;
    vec3 normal = (ns - vec3(0.5, 0.5, 0.5)) * vec3(2,2,2);

    float light_str = max(dot(light_dir, normal),0.0);

    vec3 bpv = normalize(-normalize(eyeVec) + light_dir);
    float spec = pow(dot(bpv, normal), 30.0);

	gl_FragColor = diffuse * light_str + vec4(1,0.5,1,1)*spec;
}
