/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import java.util.Vector;
import vitamin.VParticle;
import vitamin.math.Vector3;

public abstract class VParticleSystem {
    protected int _type;
    protected int _blendMode;
    protected Vector<VParticle> _particleList = new Vector();
    protected Vector3 _origin;
    protected Vector3 _originArea;

    public VParticleSystem() {
        this._origin = new Vector3(0.0f, 0.0f, 0.0f);
    }

    public VParticleSystem(Vector3 origin) {
        this._origin = origin;
    }

    public VParticleSystem(Vector3 origin, Vector3 area) {
        this._origin = origin;
        this._originArea = area;
    }

    public void setOrigin(Vector3 o) {
        this._origin = o;
    }

    public void setOrigin(Vector3 o, Vector3 area) {
        this._origin = o;
        this._originArea = area;
    }

    public void setOriginArea(Vector3 area) {
        this._originArea = area;
    }

    public void addParticle(VParticle p) {
        this._particleList.add(p);
    }

    public void addParticle(VParticle p, int tex) {
        this._particleList.add(p);
    }

    public void addParticle(Vector3 pos, Vector3 vel, Vector3 accel, float timeToLive) {
        this._particleList.add(new VParticle(pos, vel, accel, timeToLive));
    }

    public void addParticle(Vector3 pos, Vector3 vel, Vector3 accel, float timeToLive, int tex) {
        this._particleList.add(new VParticle(pos, vel, accel, timeToLive));
    }

    public void applyForce(Vector3 force) {
        int i = 0;
        while (i < this._particleList.size()) {
            VParticle p = this._particleList.get(i);
            p.applyForce(force);
            ++i;
        }
    }

    public abstract void render();

    public abstract void update(float var1, float var2);
}

