/*
    Invtro for Inércia Demoparty 2010

    http://creativecommons.org/licenses/by-nc-sa/2.5/
    
    Victor Martins
    www.pixelnerve.com
    
    Handle each seed (shape+text)
*/

import vitamin.interpolation.*;

class Seed
{
    static final boolean renderText = true;




    Seed( Vector3 center, Vector3 accel, float radius )
    {
        _damp = 0.95;

        // Start with constant acceleration
        _accel = accel.copy();

        // Repulsion is used to make seeds move when two are overlapping. 
        // Just use partial of the init acceleration
        _repulseForce = accel.copy();
        _repulseForce.normalize();

        _vel = new Vector3();
        _pos = new Vector3( 0, 0, 0 );
        _pos.add( center );
        
        _center = center;//.copy();

        _bodyRadius = radius;


//        int idx = (int)random(0, _colors.size() );
//        _color = ((Color4)_colors.get(idx)).copy();
        _color = new Color4( 1, 1, 1, 1 );
//        setColor();

        Vector3 dir = Vector3.sub( center, _accel );
        _angle = atan2( dir.y, dir.x );// + radians(90);
        

        // Set color based on angle
        int steps = _colors.size();
//        int steps = _bubbleTex.size();
        for( int i=0; i<steps+1; i++ )
        {
            float per = i / (float)(steps);
            float per2 = (i+1) / (float)(steps);
            float ang = 2 * PI * per;
            float ang2 = 2 * PI * per2;
            
            if( (_angle+PI) >= ang && (_angle+PI) < ang2 )
            {
                _color = ((Color4)_colors.get(i%_colors.size())).copy();
                //_texIndex = i%_bubbleTex.size();
//                _bodyRadius *= random(1, 2);
//                _angle += random(-PI, PI );
            }
        }


        int rnd = (int)random(_colors.size() );
        _color = ((Color4)_colors.get(rnd)).copy();


        currActiveColor = _color;

        //_texIndex = (int)random( _bubbleTex.size() );
//        if( random(100) == 100 )    _texIndex = 1;
//        else    _texIndex = 0;

        _textIndex = scene._stringIndex;    //(int)random( textStrings.length );

        _startTime = timer.getCurrTime();
    }



    void render( float time )
    {
        Vector3 dir = Vector3.sub( _center, _pos );
        float len = dir.length();
        float normLen = len / 200.0; 
        normLen = normLen*normLen*normLen;
/**
        //
        // Render direction line
        //
        vgl.enableTexture( false );
        vgl.fill( 0, 0.2 );
        vgl.beginShape( VGL.LINES );
        vgl.vertex( 0, 0, 0 );
        vgl.vertex( _pos.x, _pos.y, _pos.z );
        vgl.endShape();
        vgl.enableTexture( true );
***/


        float t = MathUtils.clamp( Elastic.easeOut(time-_startTime, 0, 1, 4), 0, 2 );


        float textLen = 1 + textStrings[_textIndex%textStrings.length].length();

        //
        // Render shadow
        //
        vgl.pushMatrix();
        vgl.translate( Vector3.add(_pos, new Vector3(0, -4, 0)) );
        vgl.rotateZ( (180+degrees(_angle)) );
        vgl.fill( 0, 0.25 );
//        vgl.ellipse( _bodyRadius, _bodyRadius );
        vgl.rectTopLeft( _bodyRadius*t*textLen, _bodyRadius*2*t );
        vgl.popMatrix();


        //7
        // Render shape
        //
        vgl.pushMatrix();
        vgl.translate( _pos );
        vgl.rotateZ( (180+degrees(_angle)) );
        vgl.fill( _color.r, _color.g, _color.b, _color.a );
//        vgl.ellipse( _bodyRadius, _bodyRadius );
        vgl.rectTopLeft( _bodyRadius*t*textLen, _bodyRadius*2*t );

        boolean isWhite = false;
        if( _color.r == 1.0 && _color.g == 1.0 && _color.b == 1.0 )
            isWhite = true;

        float fadeToBlack = MathUtils.clamp( (time-_startTime)*0.025, 0, 1 );
        fadeToBlack = fadeToBlack*fadeToBlack;
        
        if( renderText && fadeToBlack < 1.0 )
        {
            vgl.translate( _bodyRadius, _bodyRadius*0.5, 0 );
            float maxSize = ((HEIGHT / (float)WIDTH) * 15) * 10;
            if( _texIndex > 2 || isWhite ) textRender.setColor( 0, 0, 0, 1-fadeToBlack );
            else textRender.setColor( 1, 1, 1, 1-fadeToBlack );
            textRender.print( textStrings[_textIndex%textStrings.length], 0, 0, 0, (0.2+(_bodyRadius/maxSize))*t );
        }
        vgl.popMatrix();


/*
        //
        // Render text
        //
        vgl.pushMatrix();
        vgl.translate( 100+_pos.x, -0+_pos.y, 0 );
        vgl.rotateZ( 180+degrees(_angle) );
//        vgl.rotateZ( len+(180*_vel.x)+degrees(_angle) );
        vgl.fill( _color.r, _color.g, _color.b, _color.a );
//        textRender.setColor( _color.r, _color.g, _color.b, _color.a );
        
        float maxSize = ((HEIGHT / (float)WIDTH) * 15) * 5;
        if( _bodyRadius < 15 ) textRender.setColor( 0, 0, 0, 1 );
        else textRender.setColor( 1, 1, 1, 1 );
        textRender.print( textStrings[_textIndex], 0, 0, 0, _bodyRadius/maxSize );
        vgl.popMatrix();*/
    }



    void update( float time, float maxRadius )
    {
        _vel.add( _accel );
        _pos.add( _vel );
        
        // damp velocity
        _vel.mul( _damp );

        // reset acceleration per frame
        _accel.reset();

        
 /*        Vector3 vec = Vector3.sub( _pos, Vector3.ZERO );
        float dist = vec.length();
        if( dist > maxRadius )
        {
            _damp = 0.1;
        }*/
        
        
//        Vector3 dir = Vector3.sub( _center, _pos );
//        float intensity = dir.length() / (float)(HEIGHT*0.5);
//        _color.set( intensity, intensity, intensity, 1 );
        _color.a = MathUtils.clamp( time-_startTime, 0, 1 );
    }


    void applyRepulseForce()
    {
//        _accel = _repulseForce.copy();
//        _accel.mul( 0.001 );
        _vel = _repulseForce.copy();
        _vel.mul( (1-_damp) );
    }



    void setColor() 
    {
        _color.r = random(1);    //Color4.toFloat( palette[colorIndex][0] );
        _color.g = random(1);    //Color4.toFloat( palette[colorIndex][1] );
        _color.b = random(1);    //Color4.toFloat( palette[colorIndex][2] );
        _color.a = 1.0;
        //colorIndex = (colorIndex + 1) % palette.length;
    }


    //_______________________________________________________________
    //    Members
    //
    
    float _startTime;    // time this seed was created
    
    int _texIndex;

    Color4 _color;
    
    int _textIndex;

    float _bodyRadius;
    float _angle;

    float _damp;

    Vector3 _repulseForce;

    Vector3 _center;
    
    Vector3 _accel;
    Vector3 _vel;
    Vector3 _pos;
}

