/*
 * Decompiled with CFR 0.152.
 */
package vitamin;

import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import vitamin.VImage;
import vitamin.VSamplerState;
import vitamin.VTexture;

public class VTextureCUBE
extends VTexture {
    public static final int CUBE_FACE_POSITIVE_X = 0;
    public static final int CUBE_FACE_NEGATIVE_X = 1;
    public static final int CUBE_FACE_POSITIVE_Y = 2;
    public static final int CUBE_FACE_NEGATIVE_Y = 3;
    public static final int CUBE_FACE_POSITIVE_Z = 4;
    public static final int CUBE_FACE_NEGATIVE_Z = 5;
    final int[] _targets = new int[]{34069, 34070, 34071, 34072, 34073, 34074};
    public boolean _keepBitmaps = false;
    VImage[] _targetImages;

    public VTextureCUBE(GL gl) {
        super(gl);
        this._targetID = 34067;
        this._targetImages = new VImage[6];
        int i = 0;
        while (i < 6) {
            this._targetImages[i] = new VImage();
            ++i;
        }
    }

    public int getFace(int idx) {
        return this._targets[idx];
    }

    public boolean create(int width, int height, int depth, int surfaceFormat) {
        VSamplerState samp = new VSamplerState();
        samp._minFilter = 9729;
        samp._magFilter = 9729;
        samp._wrapR = 33071;
        samp._wrapS = 33071;
        samp._wrapT = 33071;
        this.create(width, height, depth, surfaceFormat, samp);
        return true;
    }

    public void create(int width, int height, int depth, int surfaceFormat, VSamplerState samp) {
        this._width = width;
        this._height = height;
        this._format = surfaceFormat;
        int srcType = GLDataTypes[surfaceFormat];
        int internalFormat = GLInternalFormats[surfaceFormat];
        int srcFormat = GLFormats[surfaceFormat];
        if (samp != null) {
            this.setSamplerState(samp);
        } else {
            this.setSamplerState(33071, 33071, 33071, 9729, 9729, 16);
        }
        int[] id = new int[1];
        this._gl.glGenTextures(1, id, 0);
        this._id = id[0];
        this._gl.glBindTexture(this._targetID, this._id);
        this._gl.glTexParameteri(this._targetID, 10242, this._samplerState._wrapS);
        this._gl.glTexParameteri(this._targetID, 10243, this._samplerState._wrapT);
        this._gl.glTexParameteri(this._targetID, 32882, this._samplerState._wrapR);
        this._gl.glTexParameteri(this._targetID, 10241, this._samplerState._minFilter);
        this._gl.glTexParameteri(this._targetID, 10240, this._samplerState._magFilter);
        int face = 0;
        while (face < 6) {
            this._gl.glTexImage2D(this._targets[face], 0, internalFormat, width, height, 0, srcFormat, srcType, null);
            ++face;
        }
    }

    public boolean loadFromFile(String folderPath, String extension, VSamplerState samp) {
        return this.loadFromFile(String.valueOf(folderPath) + "/negx." + extension, String.valueOf(folderPath) + "/posx." + extension, String.valueOf(folderPath) + "/negy." + extension, String.valueOf(folderPath) + "/posy." + extension, String.valueOf(folderPath) + "/negz." + extension, String.valueOf(folderPath) + "/posz." + extension, samp);
    }

    public boolean loadFromFile(String[] cubeFilenames, VSamplerState samp) {
        return this.loadFromFile(cubeFilenames[0], cubeFilenames[1], cubeFilenames[2], cubeFilenames[3], cubeFilenames[4], cubeFilenames[5], samp);
    }

    public boolean loadFromFile(String fileName, VSamplerState samp) {
        int i;
        VImage tex = new VImage();
        boolean flag = tex.loadFromFile(fileName);
        if (!flag) {
            return false;
        }
        int faceWidth = tex.getWidth() / 4;
        int faceHeight = tex.getHeight() / 4;
        this._targetImages[1] = new VImage(faceWidth, faceHeight, tex.getFormat());
        this._targetImages[0] = new VImage(faceWidth, faceHeight, tex.getFormat());
        this._targetImages[3] = new VImage(faceWidth, faceHeight, tex.getFormat());
        this._targetImages[2] = new VImage(faceWidth, faceHeight, tex.getFormat());
        this._targetImages[5] = new VImage(faceWidth, faceHeight, tex.getFormat());
        this._targetImages[4] = new VImage(faceWidth, faceHeight, tex.getFormat());
        int offsetX = 0;
        int offsetY = 0;
        int[] bmpArray = null;
        int x = 0;
        int y = 0;
        offsetX = faceWidth;
        offsetY = 0;
        bmpArray = new int[faceWidth * faceHeight];
        x = 0;
        y = 0;
        int j = 0 + offsetY;
        while (j < faceHeight + offsetY) {
            x = 0;
            i = 0 + offsetX;
            while (i < faceWidth + offsetX) {
                bmpArray[y * faceWidth + x] = tex.getPixel(i, j);
                ++i;
            }
            ++y;
            ++j;
        }
        this._targetImages[4].setData(bmpArray);
        bmpArray = null;
        offsetX = faceWidth;
        offsetY = faceHeight;
        bmpArray = new int[faceWidth * faceHeight];
        x = 0;
        y = 0;
        j = 0 + offsetY;
        while (j < faceHeight + offsetY) {
            x = 0;
            i = 0 + offsetX;
            while (i < faceWidth + offsetX) {
                bmpArray[y * faceWidth + x] = tex.getPixel(i, j);
                ++i;
            }
            ++y;
            ++j;
        }
        this._targetImages[4].setData(bmpArray);
        bmpArray = null;
        offsetX = faceWidth;
        offsetY = faceHeight * 2;
        bmpArray = new int[faceWidth * faceHeight];
        x = 0;
        y = 0;
        j = 0 + offsetY;
        while (j < faceHeight + offsetY) {
            x = 0;
            i = 0 + offsetX;
            while (i < faceWidth + offsetX) {
                bmpArray[y * faceWidth + x] = tex.getPixel(i, j);
                ++i;
            }
            ++y;
            ++j;
        }
        this._targetImages[4].setData(bmpArray);
        bmpArray = null;
        offsetX = faceWidth;
        offsetY = faceHeight * 3;
        bmpArray = new int[faceWidth * faceHeight];
        x = 0;
        y = 0;
        j = 0 + offsetY;
        while (j < faceHeight + offsetY) {
            x = 0;
            i = 0 + offsetX;
            while (i < faceWidth + offsetX) {
                bmpArray[y * faceWidth + x] = tex.getPixel(i, j);
                ++i;
            }
            ++y;
            ++j;
        }
        this._targetImages[4].setData(bmpArray);
        bmpArray = null;
        offsetX = 0;
        offsetY = faceHeight * 2;
        bmpArray = new int[faceWidth * faceHeight];
        x = 0;
        y = 0;
        j = 0 + offsetY;
        while (j < faceHeight + offsetY) {
            x = 0;
            i = 0 + offsetX;
            while (i < faceWidth + offsetX) {
                bmpArray[y * faceWidth + x] = tex.getPixel(i, j);
                ++i;
            }
            ++y;
            ++j;
        }
        this._targetImages[4].setData(bmpArray);
        bmpArray = null;
        offsetX = faceWidth * 2;
        offsetY = faceHeight * 2;
        bmpArray = new int[faceWidth * faceHeight];
        x = 0;
        y = 0;
        j = 0 + offsetY;
        while (j < faceHeight + offsetY) {
            x = 0;
            i = 0 + offsetX;
            while (i < faceWidth + offsetX) {
                bmpArray[y * faceWidth + x] = tex.getPixel(i, j);
                ++i;
            }
            ++y;
            ++j;
        }
        this._targetImages[4].setData(bmpArray);
        bmpArray = null;
        return true;
    }

    public boolean loadFromFile(String negXFilename, String posXFilename, String negYFilename, String posYFilename, String negZFilename, String posZFilename, VSamplerState samp) {
        try {
            this._targetImages[1] = new VImage();
            this._targetImages[1].loadFromFile(negXFilename);
            this._targetImages[0] = new VImage();
            this._targetImages[0].loadFromFile(posXFilename);
            this._targetImages[3] = new VImage();
            this._targetImages[3].loadFromFile(negYFilename);
            this._targetImages[2] = new VImage();
            this._targetImages[2].loadFromFile(posYFilename);
            this._targetImages[5] = new VImage();
            this._targetImages[5].loadFromFile(negZFilename);
            this._targetImages[4] = new VImage();
            this._targetImages[4].loadFromFile(posZFilename);
            this.process(samp);
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
        return true;
    }

    public boolean process(VSamplerState samp) {
        try {
            this._width = this._targetImages[1].getWidth();
            this._height = this._targetImages[1].getHeight();
            switch (this._targetImages[1].getFormat()) {
                case 0: {
                    this._format = 1;
                    break;
                }
                case 4: {
                    this._format = 1;
                    break;
                }
                case 1: {
                    this._format = 3;
                    break;
                }
                case 2: {
                    this._format = 5;
                    break;
                }
                case 3: {
                    this._format = 5;
                    break;
                }
                case 5: {
                    this._format = 17;
                    break;
                }
                case 6: {
                    this._format = 18;
                    break;
                }
                default: {
                    this._format = 18;
                }
            }
            int internalFormat = GLInternalFormats[this._format];
            int srcFormat = GLFormats[this._format];
            int srcType = GLDataTypes[this._format];
            System.out.println("(VTexture3D) Texture Face Info: " + this._width + ", " + this._height + ",  Format: " + this._format);
            if (samp != null) {
                this.setSamplerState(samp);
            } else {
                this.setSamplerState(33071, 33071, 33071, 9987, 9729, 16);
            }
            int[] texId = new int[1];
            this._gl.glGenTextures(1, texId, 0);
            this._id = texId[0];
            this._gl.glEnable(34067);
            this._gl.glBindTexture(34067, this._id);
            this._gl.glTexParameteri(34067, 10240, this._samplerState._magFilter);
            this._gl.glTexParameteri(34067, 10241, this._samplerState._minFilter);
            this._gl.glTexParameteri(34067, 10242, this._samplerState._wrapS);
            this._gl.glTexParameteri(34067, 10243, this._samplerState._wrapT);
            this._gl.glTexParameteri(34067, 32882, this._samplerState._wrapR);
            this._gl.glTexParameteri(this._targetID, 33169, 1);
            this._gl.glGenerateMipmapEXT(this._targetID);
            int i = 0;
            while (i < 6) {
                this._gl.glTexImage2D(this._targets[i], 0, internalFormat, this._width, this._height, 0, srcFormat, srcType, (Buffer)IntBuffer.wrap(this._targetImages[i].getData()));
                ++i;
            }
            this._gl.glDisable(34067);
            this._gl.glBindTexture(34067, 0);
        }
        catch (Exception e) {
            System.out.println(e);
            return false;
        }
        return true;
    }

    public void keepBitmap(boolean f) {
        this._keepBitmaps = f;
    }
}

