/*
 * Decompiled with CFR 0.152.
 */
package vitamin.fx;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import vitamin.interpolation.Circular;
import vitamin.interpolation.Linear;
import vitamin.interpolation.Sine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimelineLayer {
    public static final int LINEAR = 0;
    public static final int COSINE = 1;
    public static final int CUBIC = 2;
    public static final int CIRCULAR = 3;
    private CustomComparator _comparator;
    String _name;
    int _currKey;
    float _currentValue;
    int _interpolationMode;
    ArrayList<Integer> _frames;
    ArrayList<LayerObject> _values;

    TimelineLayer(String name, int lerpMode) {
        this._name = name;
        this._interpolationMode = lerpMode;
        this._comparator = new CustomComparator();
        this._values = new ArrayList();
    }

    void update(float time) {
        float timeClamped = 0.0f;
        float endTime = this._values.get((int)(this._values.size() - 1))._time;
        timeClamped = time >= endTime ? endTime : time;
        int key = 0;
        int key1 = 0;
        int key2 = 1;
        while (key < this._values.size() && this._values.get((int)key)._time < timeClamped) {
            ++key;
        }
        if (key < 0) {
            key = 0;
        }
        if (key >= this._values.size()) {
            key = this._values.size() - 1;
        }
        key1 = key - 1;
        key2 = key;
        if (key1 < 0) {
            ++key1;
            ++key2;
        }
        this._currKey = key1;
        LayerObject before = this._values.get(key1);
        LayerObject after = this._values.get(key2);
        float t = (timeClamped - before._time) / (after._time - before._time);
        float d0 = before._value;
        float d1 = after._value;
        switch (this._interpolationMode) {
            case 0: {
                this._currentValue = Linear.easeNone(t, d0, d1, 1.0f);
                break;
            }
            case 1: {
                this._currentValue = Sine.easeIn(t, d0, d1, 1.0f);
                break;
            }
            case 2: {
                System.err.println("(TimelineLayer) Cubic interpolation still not supported");
                break;
            }
            case 3: {
                this._currentValue = Circular.easeIn(t, d0, d1, 1.0f);
                break;
            }
            default: {
                this._currentValue = Linear.easeIn(t, d0, d1, 1.0f);
            }
        }
    }

    void addValue(float time, float val) {
        if ((double)time < 0.0) {
            System.err.println("(TimelineLayer) Time can't be negative");
            return;
        }
        LayerObject lo = new LayerObject(time, val);
        this._values.add(lo);
        Collections.sort(this._values, this._comparator);
    }

    String getName() {
        return this._name;
    }

    ArrayList<LayerObject> getValues() {
        return this._values;
    }

    float getCurrValue() {
        return this._currentValue;
    }

    void release() {
        this._values.clear();
        this._name = null;
        this._comparator = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CustomComparator
    implements Comparator<LayerObject>,
    Serializable {
        private static final long serialVersionUID = 1L;

        CustomComparator() {
        }

        @Override
        public int compare(LayerObject a, LayerObject b) {
            if (a._time < b._time) {
                return -1;
            }
            if (b._time - a._time < 1.0E-5f) {
                return 0;
            }
            return 1;
        }
    }

    class LayerObject {
        float _time;
        float _value;

        LayerObject(float t, float v) {
            this._time = t;
            this._value = v;
        }
    }
}

