/*
 * Decompiled with CFR 0.152.
 */
package vitamin.math;

import javax.media.opengl.GL;
import vitamin.math.MathUtils;
import vitamin.math.Matrix;
import vitamin.math.Plane;
import vitamin.math.Vector3;
import vitamin.scenesimple.BoundingSphere;

public class Frustum {
    private static final int FRUSTUM_TOP = 0;
    private static final int FRUSTUM_BOTTOM = 1;
    private static final int FRUSTUM_LEFT = 2;
    private static final int FRUSTUM_RIGHT = 3;
    private static final int FRUSTUM_NEAR = 4;
    private static final int FRUSTUM_FAR = 5;
    Matrix _projMatrix;
    Matrix _viewMatrix;
    Matrix _finalMatrix;
    Plane[] _planes;
    Vector3[] _vertices;
    Vector3 _camPos = new Vector3();
    Vector3 _camLookAt = new Vector3();
    Vector3 _camUp = Vector3.UP;
    float _fov = 45.0f;
    float _aspectRatio = 1.3333334f;
    float _nearPlane = 1.0f;
    float _farPlane = 1000.0f;
    boolean _doFill = true;

    public Frustum() {
        this._planes = new Plane[6];
        int i = 0;
        while (i < 6) {
            this._planes[i] = new Plane();
            ++i;
        }
        this._projMatrix = new Matrix();
        this._viewMatrix = new Matrix();
        this._finalMatrix = new Matrix();
        this._vertices = new Vector3[8];
    }

    public void setProjectionParams(float fov, float aspectRatio, float near, float far) {
        this._fov = fov;
        this._aspectRatio = aspectRatio;
        this._nearPlane = near;
        this._farPlane = far;
    }

    public void setCameraParams(Vector3 camPos, Vector3 lookAt, Vector3 up) {
        this._camPos.set(camPos);
        this._camLookAt.set(lookAt);
        this._camUp.set(up);
    }

    public void setCameraParams(float ex, float ey, float ez, float tx, float ty, float tz, float ux, float uy, float uz) {
        this._camPos.set(ex, ey, ez);
        this._camLookAt.set(tx, ty, tz);
        this._camUp.set(ux, uy, uz);
    }

    public void updateByMatrix(GL _gl) {
        _gl.glGetFloatv(2982, this._viewMatrix._M, 0);
        _gl.glGetFloatv(2983, this._projMatrix._M, 0);
        _gl.glPushMatrix();
        _gl.glLoadMatrixf(this._projMatrix.getFloatBuffer());
        _gl.glMultMatrixf(this._viewMatrix.getFloatBuffer());
        _gl.glGetFloatv(2982, this._finalMatrix._M, 0);
        _gl.glPopMatrix();
        float[] m = new float[16];
        int i = 0;
        while (i < 16) {
            m[i] = this._finalMatrix._M[i];
            ++i;
        }
        this._planes[0]._normal.x = m[3] - m[0];
        this._planes[0]._normal.y = m[7] - m[4];
        this._planes[0]._normal.z = m[11] - m[8];
        this._planes[0]._d = m[15] - m[12];
        this._planes[1]._normal.x = m[3] + m[0];
        this._planes[1]._normal.y = m[7] + m[4];
        this._planes[1]._normal.z = m[11] + m[8];
        this._planes[1]._d = m[15] + m[12];
        this._planes[2]._normal.x = m[3] - m[1];
        this._planes[2]._normal.y = m[7] - m[5];
        this._planes[2]._normal.z = m[11] - m[9];
        this._planes[2]._d = m[15] - m[13];
        this._planes[3]._normal.x = m[3] + m[1];
        this._planes[3]._normal.y = m[7] + m[5];
        this._planes[3]._normal.z = m[11] + m[9];
        this._planes[3]._d = m[15] + m[13];
        this._planes[4]._normal.x = m[3] - m[2];
        this._planes[4]._normal.y = m[7] - m[6];
        this._planes[4]._normal.z = m[11] - m[10];
        this._planes[4]._d = m[15] - m[14];
        this._planes[5]._normal.x = m[3] + m[2];
        this._planes[5]._normal.y = m[7] + m[6];
        this._planes[5]._normal.z = m[11] + m[10];
        this._planes[5]._d = m[15] + m[14];
        i = 0;
        while (i < 6) {
            this._planes[i].normalize();
            ++i;
        }
    }

    public void updateByMatrix(GL gl, Matrix _viewMatrix, Matrix _projMatrix) {
        gl.glPushMatrix();
        gl.glLoadMatrixf(_projMatrix.getFloatBuffer());
        gl.glMultMatrixf(_viewMatrix.getFloatBuffer());
        gl.glGetFloatv(2982, this._finalMatrix._M, 0);
        gl.glPopMatrix();
        float[] m = new float[16];
        int i = 0;
        while (i < 16) {
            m[i] = this._finalMatrix._M[i];
            ++i;
        }
        this._planes[0]._normal.x = m[3] - m[0];
        this._planes[0]._normal.y = m[7] - m[4];
        this._planes[0]._normal.z = m[11] - m[8];
        this._planes[0]._d = m[15] - m[12];
        this._planes[1]._normal.x = m[3] + m[0];
        this._planes[1]._normal.y = m[7] + m[4];
        this._planes[1]._normal.z = m[11] + m[8];
        this._planes[1]._d = m[15] + m[12];
        this._planes[2]._normal.x = m[3] - m[1];
        this._planes[2]._normal.y = m[7] - m[5];
        this._planes[2]._normal.z = m[11] - m[9];
        this._planes[2]._d = m[15] - m[13];
        this._planes[3]._normal.x = m[3] + m[1];
        this._planes[3]._normal.y = m[7] + m[5];
        this._planes[3]._normal.z = m[11] + m[9];
        this._planes[3]._d = m[15] + m[13];
        this._planes[4]._normal.x = m[3] - m[2];
        this._planes[4]._normal.y = m[7] - m[6];
        this._planes[4]._normal.z = m[11] - m[10];
        this._planes[4]._d = m[15] - m[14];
        this._planes[5]._normal.x = m[3] + m[2];
        this._planes[5]._normal.y = m[7] + m[6];
        this._planes[5]._normal.z = m[11] + m[10];
        this._planes[5]._d = m[15] + m[14];
        i = 0;
        while (i < 6) {
            this._planes[i].normalize();
            ++i;
        }
    }

    public void update(float fov, float aspectRatio, float near, float far, Vector3 camPos, Vector3 lookAt, Vector3 up) {
        this.setProjectionParams(fov, aspectRatio, near, far);
        this.setCameraParams(camPos, lookAt, up);
        float radians = (float)Math.tan((double)MathUtils.radians(fov) * 0.5);
        float nearH = near * radians;
        float nearW = nearH * aspectRatio;
        float farH = far * radians;
        float farW = farH * aspectRatio;
        Vector3 zVec = Vector3.sub(camPos, lookAt);
        zVec.normalize();
        Vector3 xVec = Vector3.cross(up, zVec);
        xVec.normalize();
        Vector3 yVec = Vector3.cross(zVec, xVec);
        Vector3 zNear = Vector3.mul(zVec, near);
        Vector3 vecN = Vector3.sub(camPos, zNear);
        Vector3 zFar = Vector3.mul(zVec, far);
        Vector3 vecF = Vector3.sub(camPos, zFar);
        Vector3 xNearW = Vector3.mul(xVec, nearW);
        Vector3 xFarW = Vector3.mul(xVec, farW);
        Vector3 yNearH = Vector3.mul(yVec, nearH);
        Vector3 yFarH = Vector3.mul(yVec, farH);
        Vector3 nearTopLeft = Vector3.add(vecN, yNearH);
        nearTopLeft.sub(xNearW);
        Vector3 nearTopRight = Vector3.add(vecN, yNearH);
        nearTopRight.add(xNearW);
        Vector3 nearBottomLeft = Vector3.sub(vecN, yNearH);
        nearBottomLeft.sub(xNearW);
        Vector3 nearBottomRight = Vector3.sub(vecN, yNearH);
        nearBottomRight.add(xNearW);
        Vector3 farTopLeft = Vector3.add(vecF, yFarH);
        farTopLeft.sub(xFarW);
        Vector3 farTopRight = Vector3.add(vecF, yFarH);
        farTopRight.add(xFarW);
        Vector3 farBottomLeft = Vector3.sub(vecF, yFarH);
        farBottomLeft.sub(xFarW);
        Vector3 farBottomRight = Vector3.sub(vecF, yFarH);
        farBottomRight.add(xFarW);
        this._planes[0].redefine(nearTopRight, nearTopLeft, farTopLeft);
        this._planes[1].redefine(nearBottomLeft, nearBottomRight, farBottomRight);
        this._planes[2].redefine(nearTopLeft, nearBottomLeft, farBottomLeft);
        this._planes[3].redefine(nearBottomRight, nearTopRight, farBottomRight);
        this._planes[4].redefine(nearTopLeft, nearTopRight, nearBottomRight);
        this._planes[5].redefine(farTopRight, farTopLeft, farBottomLeft);
        this._vertices[0] = nearTopLeft;
        this._vertices[1] = nearTopRight;
        this._vertices[2] = nearBottomRight;
        this._vertices[3] = nearBottomLeft;
        this._vertices[4] = farTopLeft;
        this._vertices[5] = farTopRight;
        this._vertices[6] = farBottomRight;
        this._vertices[7] = farBottomLeft;
    }

    public void update(float fov, float aspectRatio, float near, float far, float ex, float ey, float ez, float tx, float ty, float tz, float ux, float uy, float uz) {
        this.setProjectionParams(fov, aspectRatio, near, far);
        this.setCameraParams(ex, ey, ez, tx, ty, tz, ux, uy, uz);
        float radians = (float)Math.tan((double)MathUtils.radians(fov) * 0.5);
        float nearH = near * radians;
        float nearW = nearH * aspectRatio;
        float farH = far * radians;
        float farW = farH * aspectRatio;
        Vector3 camPos = new Vector3(ex, ey, ez);
        Vector3 lookAt = new Vector3(tx, ty, tz);
        Vector3 up = new Vector3(ux, uy, uz);
        Vector3 zVec = Vector3.sub(camPos, lookAt);
        zVec.normalize();
        Vector3 xVec = Vector3.cross(up, zVec);
        xVec.normalize();
        Vector3 yVec = Vector3.cross(zVec, xVec);
        Vector3 zNear = Vector3.mul(zVec, near);
        Vector3 vecN = Vector3.sub(camPos, zNear);
        Vector3 zFar = Vector3.mul(zVec, far);
        Vector3 vecF = Vector3.sub(camPos, zFar);
        Vector3 xNearW = Vector3.mul(xVec, nearW);
        Vector3 xFarW = Vector3.mul(xVec, farW);
        Vector3 yNearH = Vector3.mul(yVec, nearH);
        Vector3 yFarH = Vector3.mul(yVec, farH);
        Vector3 nearTopLeft = Vector3.add(vecN, yNearH);
        nearTopLeft.sub(xNearW);
        Vector3 nearTopRight = Vector3.add(vecN, yNearH);
        nearTopRight.add(xNearW);
        Vector3 nearBottomLeft = Vector3.sub(vecN, yNearH);
        nearBottomLeft.sub(xNearW);
        Vector3 nearBottomRight = Vector3.sub(vecN, yNearH);
        nearBottomRight.add(xNearW);
        Vector3 farTopLeft = Vector3.add(vecF, yFarH);
        farTopLeft.sub(xFarW);
        Vector3 farTopRight = Vector3.add(vecF, yFarH);
        farTopRight.add(xFarW);
        Vector3 farBottomLeft = Vector3.sub(vecF, yFarH);
        farBottomLeft.sub(xFarW);
        Vector3 farBottomRight = Vector3.sub(vecF, yFarH);
        farBottomRight.add(xFarW);
        this._planes[0].redefine(nearTopRight, nearTopLeft, farTopLeft);
        this._planes[1].redefine(nearBottomLeft, nearBottomRight, farBottomRight);
        this._planes[2].redefine(nearTopLeft, nearBottomLeft, farBottomLeft);
        this._planes[3].redefine(nearBottomRight, nearTopRight, farBottomRight);
        this._planes[4].redefine(nearTopLeft, nearTopRight, nearBottomRight);
        this._planes[5].redefine(farTopRight, farTopLeft, farBottomLeft);
        this._vertices[0] = nearTopLeft;
        this._vertices[1] = nearTopRight;
        this._vertices[2] = nearBottomRight;
        this._vertices[3] = nearBottomLeft;
        this._vertices[4] = farTopLeft;
        this._vertices[5] = farTopRight;
        this._vertices[6] = farBottomRight;
        this._vertices[7] = farBottomLeft;
    }

    public void update() {
        float radians = (float)Math.tan((double)MathUtils.radians(this._fov) * 0.5);
        float nearH = this._nearPlane * radians;
        float nearW = nearH * this._aspectRatio;
        float farH = this._farPlane * radians;
        float farW = farH * this._aspectRatio;
        Vector3 zVec = Vector3.sub(this._camPos, this._camLookAt);
        zVec.normalize();
        Vector3 xVec = Vector3.cross(this._camUp, zVec);
        xVec.normalize();
        Vector3 yVec = Vector3.cross(zVec, xVec);
        Vector3 zNear = Vector3.mul(zVec, this._nearPlane);
        Vector3 vecN = Vector3.sub(this._camPos, zNear);
        Vector3 zFar = Vector3.mul(zVec, this._farPlane);
        Vector3 vecF = Vector3.sub(this._camPos, zFar);
        Vector3 xNearW = Vector3.mul(xVec, nearW);
        Vector3 xFarW = Vector3.mul(xVec, farW);
        Vector3 yNearH = Vector3.mul(yVec, nearH);
        Vector3 yFarH = Vector3.mul(yVec, farH);
        Vector3 nearTopLeft = Vector3.add(vecN, yNearH);
        nearTopLeft.sub(xNearW);
        Vector3 nearTopRight = Vector3.add(vecN, yNearH);
        nearTopRight.add(xNearW);
        Vector3 nearBottomLeft = Vector3.sub(vecN, yNearH);
        nearBottomLeft.sub(xNearW);
        Vector3 nearBottomRight = Vector3.sub(vecN, yNearH);
        nearBottomRight.add(xNearW);
        Vector3 farTopLeft = Vector3.add(vecF, yFarH);
        farTopLeft.sub(xFarW);
        Vector3 farTopRight = Vector3.add(vecF, yFarH);
        farTopRight.add(xFarW);
        Vector3 farBottomLeft = Vector3.sub(vecF, yFarH);
        farBottomLeft.sub(xFarW);
        Vector3 farBottomRight = Vector3.sub(vecF, yFarH);
        farBottomRight.add(xFarW);
        this._planes[0].redefine(nearTopRight, nearTopLeft, farTopLeft);
        this._planes[1].redefine(nearBottomLeft, nearBottomRight, farBottomRight);
        this._planes[2].redefine(nearTopLeft, nearBottomLeft, farBottomLeft);
        this._planes[3].redefine(nearBottomRight, nearTopRight, farBottomRight);
        this._planes[4].redefine(nearTopLeft, nearTopRight, nearBottomRight);
        this._planes[5].redefine(farTopRight, farTopLeft, farBottomLeft);
        this._vertices[0] = nearTopLeft;
        this._vertices[1] = nearTopRight;
        this._vertices[2] = nearBottomRight;
        this._vertices[3] = nearBottomLeft;
        this._vertices[4] = farTopLeft;
        this._vertices[5] = farTopRight;
        this._vertices[6] = farBottomRight;
        this._vertices[7] = farBottomLeft;
    }

    public boolean isPointVisible(Vector3 p) {
        float distance = 0.0f;
        int i = 0;
        while (i < 6) {
            distance = this._planes[i].distance(p);
            if (distance < 0.0f) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isPointVisible(float x, float y, float z) {
        Vector3 p = new Vector3(x, y, z);
        float distance = 0.0f;
        int i = 0;
        while (i < 6) {
            distance = this._planes[i].distance(p);
            if (distance < 0.0f) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isSphereVisible(Vector3 center, float radius) {
        float distance = 0.0f;
        int i = 0;
        while (i < 6) {
            distance = this._planes[i].distance(center);
            if (distance < -radius) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isSphereVisible(BoundingSphere bs) {
        float distance = 0.0f;
        int i = 0;
        while (i < 6) {
            distance = this._planes[i].distance(bs._center);
            if (distance < -bs._radius) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public boolean isCubeVisible(float x, float y, float z, float size) {
        float minX = x - size * 0.5f;
        float maxX = x + size * 0.5f;
        float minY = y - size * 0.5f;
        float maxY = y + size * 0.5f;
        float minZ = z - size * 0.5f;
        float maxZ = z + size * 0.5f;
        return this.isBoxVisible(new Vector3(minX, minY, minZ), new Vector3(maxX, maxY, maxZ));
    }

    public boolean isBoxVisible(float x, float y, float z, float sizeX, float sizeY, float sizeZ) {
        float minX = x - sizeX * 0.5f;
        float maxX = x + sizeX * 0.5f;
        float minY = y - sizeY * 0.5f;
        float maxY = y + sizeY * 0.5f;
        float minZ = z - sizeZ * 0.5f;
        float maxZ = z + sizeZ * 0.5f;
        return this.isBoxVisible(new Vector3(minX, minY, minZ), new Vector3(maxX, maxY, maxZ));
    }

    public boolean isBoxVisible(Vector3 min, Vector3 max) {
        if (this.isPointVisible(min.x, min.y, min.z)) {
            return true;
        }
        if (this.isPointVisible(max.x, min.y, min.z)) {
            return true;
        }
        if (this.isPointVisible(min.x, max.y, min.z)) {
            return true;
        }
        if (this.isPointVisible(max.x, max.y, min.z)) {
            return true;
        }
        if (this.isPointVisible(min.x, min.y, max.z)) {
            return true;
        }
        if (this.isPointVisible(max.x, min.y, max.z)) {
            return true;
        }
        if (this.isPointVisible(min.x, max.y, max.z)) {
            return true;
        }
        return this.isPointVisible(max.x, max.y, max.z);
    }

    public void render(GL _gl) {
        _gl.glDisable(3553);
        if (this._doFill) {
            _gl.glBegin(7);
            _gl.glColor4f(1.0f, 0.0f, 0.0f, 0.2f);
            _gl.glVertex3f(this._vertices[0].x, this._vertices[0].y, this._vertices[0].z);
            _gl.glVertex3f(this._vertices[1].x, this._vertices[1].y, this._vertices[1].z);
            _gl.glVertex3f(this._vertices[2].x, this._vertices[2].y, this._vertices[2].z);
            _gl.glVertex3f(this._vertices[3].x, this._vertices[3].y, this._vertices[3].z);
            _gl.glVertex3f(this._vertices[4].x, this._vertices[4].y, this._vertices[4].z);
            _gl.glVertex3f(this._vertices[5].x, this._vertices[5].y, this._vertices[5].z);
            _gl.glVertex3f(this._vertices[6].x, this._vertices[6].y, this._vertices[6].z);
            _gl.glVertex3f(this._vertices[7].x, this._vertices[7].y, this._vertices[7].z);
            _gl.glVertex3f(this._vertices[0].x, this._vertices[0].y, this._vertices[0].z);
            _gl.glVertex3f(this._vertices[4].x, this._vertices[4].y, this._vertices[4].z);
            _gl.glVertex3f(this._vertices[7].x, this._vertices[7].y, this._vertices[7].z);
            _gl.glVertex3f(this._vertices[3].x, this._vertices[3].y, this._vertices[3].z);
            _gl.glVertex3f(this._vertices[1].x, this._vertices[1].y, this._vertices[1].z);
            _gl.glVertex3f(this._vertices[5].x, this._vertices[5].y, this._vertices[5].z);
            _gl.glVertex3f(this._vertices[6].x, this._vertices[6].y, this._vertices[6].z);
            _gl.glVertex3f(this._vertices[2].x, this._vertices[2].y, this._vertices[2].z);
            _gl.glVertex3f(this._vertices[4].x, this._vertices[4].y, this._vertices[4].z);
            _gl.glVertex3f(this._vertices[5].x, this._vertices[5].y, this._vertices[5].z);
            _gl.glVertex3f(this._vertices[1].x, this._vertices[1].y, this._vertices[1].z);
            _gl.glVertex3f(this._vertices[0].x, this._vertices[0].y, this._vertices[0].z);
            _gl.glVertex3f(this._vertices[6].x, this._vertices[6].y, this._vertices[6].z);
            _gl.glVertex3f(this._vertices[7].x, this._vertices[7].y, this._vertices[7].z);
            _gl.glVertex3f(this._vertices[3].x, this._vertices[3].y, this._vertices[3].z);
            _gl.glVertex3f(this._vertices[2].x, this._vertices[2].y, this._vertices[2].z);
            _gl.glEnd();
        }
        _gl.glBegin(3);
        _gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        _gl.glVertex3f(this._vertices[0].x, this._vertices[0].y, this._vertices[0].z);
        _gl.glVertex3f(this._vertices[1].x, this._vertices[1].y, this._vertices[1].z);
        _gl.glVertex3f(this._vertices[2].x, this._vertices[2].y, this._vertices[2].z);
        _gl.glVertex3f(this._vertices[3].x, this._vertices[3].y, this._vertices[3].z);
        _gl.glVertex3f(this._vertices[0].x, this._vertices[0].y, this._vertices[0].z);
        _gl.glEnd();
        _gl.glBegin(3);
        _gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        _gl.glVertex3f(this._vertices[4].x, this._vertices[4].y, this._vertices[4].z);
        _gl.glVertex3f(this._vertices[5].x, this._vertices[5].y, this._vertices[5].z);
        _gl.glVertex3f(this._vertices[6].x, this._vertices[6].y, this._vertices[6].z);
        _gl.glVertex3f(this._vertices[7].x, this._vertices[7].y, this._vertices[7].z);
        _gl.glVertex3f(this._vertices[4].x, this._vertices[4].y, this._vertices[4].z);
        _gl.glEnd();
        _gl.glBegin(1);
        _gl.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        _gl.glVertex3f(this._vertices[0].x, this._vertices[0].y, this._vertices[0].z);
        _gl.glVertex3f(this._vertices[4].x, this._vertices[4].y, this._vertices[4].z);
        _gl.glVertex3f(this._vertices[1].x, this._vertices[1].y, this._vertices[1].z);
        _gl.glVertex3f(this._vertices[5].x, this._vertices[5].y, this._vertices[5].z);
        _gl.glVertex3f(this._vertices[2].x, this._vertices[2].y, this._vertices[2].z);
        _gl.glVertex3f(this._vertices[6].x, this._vertices[6].y, this._vertices[6].z);
        _gl.glVertex3f(this._vertices[3].x, this._vertices[3].y, this._vertices[3].z);
        _gl.glVertex3f(this._vertices[7].x, this._vertices[7].y, this._vertices[7].z);
        _gl.glEnd();
    }

    public void enableFillMode(boolean f) {
        this._doFill = f;
    }
}

