////////////////////////////////////////////////////////////////////////////////////////////////////
// sprite.fx                                                                                
////////////////////////////////////////////////////////////////////////////////////////////////////



// Transforms
////////////////////////////////////////////////////////////////////////////////////////////////////
float4x4 g_wvp_mtx;
float4 g_offset;



// T E X T U R E S
////////////////////////////////////////////////////////////////////////////////////////////////////
texture2D g_sprite_tex;
texture2D g_noise_tex;



// S A M P L E R S
////////////////////////////////////////////////////////////////////////////////////////////////////
sampler2D g_sprite_samp = sampler_state 
{
		texture = <g_sprite_tex>;
		MinFilter = LINEAR;
		MagFilter = LINEAR;
		MipFilter = LINEAR;
		AddressU  = CLAMP;        
		AddressV  = CLAMP;
		AddressW  = CLAMP;
};



////////////////////////////////////////////////////////////////////////////////////////////////////
sampler2D g_noise_samp = sampler_state 
{
		texture = <g_noise_tex>;
		MinFilter = LINEAR;
		MagFilter = LINEAR;
		MipFilter = LINEAR;
		AddressU  = WRAP;        
		AddressV  = WRAP;
		AddressW  = WRAP;
};



// Vertex shaders
////////////////////////////////////////////////////////////////////////////////////////////////////
void vs_sprite(
    in float3 iPos   : POSITION0,
    in float2 iTc0   : TEXCOORD0,
    
    out float4 oVPos : POSITION,
    out float2 oTc0  : TEXCOORD0 )
{
    // Transform position to clip space
    oVPos = mul( float4( iPos.x, -iPos.y, iPos.z, 1.0 ), g_wvp_mtx );
    
    // Copy texcoord
    oTc0 = iTc0;
}



////////////////////////////////////////////////////////////////////////////////////////////////////
void vs_noise(
    in float3 iPos   : POSITION0,
    in float2 iTc0   : TEXCOORD0,
    
    out float4 oVPos : POSITION,
    out float2 oTc0  : TEXCOORD0,
    out float4 oTc1  : TEXCOORD1 )
{
    // Transform position to clip space
    oVPos = mul( float4( iPos.x, -iPos.y, iPos.z, 1.0 ), g_wvp_mtx );
    
    // Copy texcoord
    oTc0 = iTc0;

    // Copy texcoord
    oTc1.xyz = (oVPos.xyz + 1.0) * 0.5;
    oTc1.w = oVPos.w;
    oTc1.y = 1.0 - oTc1.y;
    oTc1.xy *= 4.0;
    oTc1.xy += g_offset.xy;
}



// Pixel shaders
////////////////////////////////////////////////////////////////////////////////////////////////////
float4 ps_sprite( in float2 iTc0 : TEXCOORD0 ) : COLOR0
{          
		float4 color = tex2D( g_sprite_samp, iTc0 );
		color.rgb *= 0.5;
    return color;
}                                                                                               



////////////////////////////////////////////////////////////////////////////////////////////////////
float4 ps_noise( in float2 iTc0 : TEXCOORD0,
								 in float4 iTc1 : TEXCOORD1 ) : COLOR0
{             
		float4 sprite = tex2D( g_sprite_samp, iTc0.xy );
		float4 noise = tex2D( g_noise_samp, iTc1.xy/iTc1.w );
    return saturate( noise.rrrr*sprite.a - 0.65 ) * 80.0;
}                                                                                               



// Techniques
////////////////////////////////////////////////////////////////////////////////////////////////////
technique sprite
{
   pass p0 
   {
				ZEnable = false;
		//AlphaBlendEnable = false;
        VertexShader = compile vs_3_0 vs_sprite();
        PixelShader  = compile ps_3_0 ps_sprite();
   }
}



////////////////////////////////////////////////////////////////////////////////////////////////////
technique screen_noise
{
   pass p0 
   {
				ZEnable = false;
		//AlphaBlendEnable = false;
        VertexShader = compile vs_3_0 vs_noise();
        PixelShader  = compile ps_3_0 ps_noise();
   }
}

