////////////////////////////////////////////////////////////////////////////////////////////////////
// skybox.fx
////////////////////////////////////////////////////////////////////////////////////////////////////



// Transforms
////////////////////////////////////////////////////////////////////////////////////////////////////
float4x4 g_wvp_mtx;



// Textures & samplers
////////////////////////////////////////////////////////////////////////////////////////////////////
textureCUBE g_albedo_tex;

samplerCUBE g_albedo_samp = sampler_state
{
		texture = <g_albedo_tex>;
		MinFilter = LINEAR;
		MagFilter = LINEAR;
		MipFilter = LINEAR;
		AddressU  = CLAMP;
		AddressV  = CLAMP;
		AddressW  = CLAMP;
};



// Vertex shaders
////////////////////////////////////////////////////////////////////////////////////////////////////
void vs(
		in float3 iPos : POSITION0,
		
		out float4 oPos	: POSITION,
		out float3 oTc0	: TEXCOORD0 )                                               
{
		// Transform vertex position
		oPos = mul( float4( iPos.xyz, 1.0 ), g_wvp_mtx );
		oPos.z = oPos.w;

		// Copy texcoord
		//oTc0 = iPos;
		oTc0 = float3( iPos.x, iPos.y + 0.075f, iPos.z );
}



////////////////////////////////////////////////////////////////////////////////////////////////////
void vs_reflection(
		in float3 iPos : POSITION0,
		
		out float4 oPos	: POSITION,
		out float3 oTc0	: TEXCOORD0 )                                               
{
		// Transform vertex position
		oPos = mul( float4( iPos.xyz, 1.0 ), g_wvp_mtx );
		oPos.z = oPos.w;

		// Copy texcoord
		oTc0 = float3( iPos.x, -(iPos.y + 0.075), iPos.z );
}



// Pixel shaders
////////////////////////////////////////////////////////////////////////////////////////////////////
float4 ps( in float3 iTc0 : TEXCOORD0 ) : COLOR
{
		return float4( saturate( texCUBE( g_albedo_samp, iTc0 ).rgb - 0.35f ) * 4.0, 1.0 );
}



////////////////////////////////////////////////////////////////////////////////////////////////////
float4 ps_reflection( in float3 iTc0 : TEXCOORD0 ) : COLOR
{
		return float4( saturate( texCUBE( g_albedo_samp, iTc0 ).rgb - 0.35f ) * 4.0, 1.0 );
}



// Techniques
////////////////////////////////////////////////////////////////////////////////////////////////////
technique main
{
   pass p0
   {
		AlphaBlendEnable = false;
        VertexShader = compile vs_3_0 vs();
        PixelShader = compile ps_3_0 ps();
   }
}



////////////////////////////////////////////////////////////////////////////////////////////////////
technique reflection
{
   pass p0
   {
		AlphaBlendEnable = false;
        VertexShader = compile vs_3_0 vs_reflection();
        PixelShader = compile ps_3_0 ps_reflection();
   }
}

