////////////////////////////////////////////////////////////////////////////////////////////////////
// shadow.fx                                                                                
////////////////////////////////////////////////////////////////////////////////////////////////////



// Transforms
////////////////////////////////////////////////////////////////////////////////////////////////////
float4x4 g_wvp_mtx;
float4x4 g_shadow_mtx;
float4 g_land_scale;



// Vertex shaders
////////////////////////////////////////////////////////////////////////////////////////////////////
void vs_main(
    in float3 iPos   : POSITION0,
    
    out float4 oVPos : POSITION,
    out float4 oPos  : TEXCOORD0 )
{
    // Transform position to clip space
    oVPos = mul( float4( iPos.xyz, 1.0 ), g_wvp_mtx );
    oPos = oVPos;
}



// T E X T U R E S
////////////////////////////////////////////////////////////////////////////////////////////////////
texture2D g_shadowmap_tex;



// S A M P L E R S
////////////////////////////////////////////////////////////////////////////////////////////////////
sampler2D g_shadowmap_samp = sampler_state 
{
		texture = <g_shadowmap_tex>;
		MinFilter = POINT;
		MagFilter = POINT;
		MipFilter = NONE;
		AddressU  = CLAMP;        
		AddressV  = CLAMP;
		AddressW  = CLAMP;
};



////////////////////////////////////////////////////////////////////////////////////////////////////
void vs_land(
    in float3 iPos   : POSITION0,
    
    out float4 oVPos : POSITION,
    out float4 oPos  : TEXCOORD0 )
{
    // Transform position to clip space
		float4 scaled_pos = float4( iPos.xyz * g_land_scale.xyz, 1.0 );
		scaled_pos.y *= g_land_scale.w;
		oVPos = mul( scaled_pos, g_wvp_mtx );	
    oPos = oVPos;
}




////////////////////////////////////////////////////////////////////////////////////////////////////
void vs_land_soft_shadow_texture(
    in float3 iPos         : POSITION0,
    
    out float4 oVPos       : POSITION,
    out float4 oSurfacePos : TEXCOORD0 )
{
		// Output position in texture space
		float2 tc = float2( iPos.x, 1.0 - iPos.z );
    oVPos = float4( tc.xy * 2.0 - 1.0, 1.0, 1.0 );
    
    // Transform vertex position to shadow map space
		float4 scaled_pos = float4( iPos.xyz * g_land_scale.xyz, 1.0 );
		scaled_pos.y *= g_land_scale.w;
		oSurfacePos = mul( scaled_pos, g_shadow_mtx );	
}




// Pixel shaders
////////////////////////////////////////////////////////////////////////////////////////////////////
void ps( in float4 iPos   : TEXCOORD0,

         out float4 oCol0 : COLOR0 )
{                                                                                               
    oCol0 = float4( iPos.z/iPos.w, 1.0f, 1.0f, 1.0f );
}                                                                                               



////////////////////////////////////////////////////////////////////////////////////////////////////
void ps_land_soft_shadow_texture( in float4 iSurfacePos : TEXCOORD0,
                             
                             out float4 oCol0 : COLOR0 )
{
		iSurfacePos.xyz /= iSurfacePos.w;
		float shadowmap_depth = tex2D( g_shadowmap_samp, iSurfacePos.xy ).r;
		float shadow = (shadowmap_depth + 0.00075 > iSurfacePos.z) ? 1.0 : 0.0;		
    oCol0 = float4( shadow, shadow, shadow, 0.05f );
}                                                                                               



// Techniques
////////////////////////////////////////////////////////////////////////////////////////////////////
technique main
{
   pass p0 
   {
				ZEnable = true;
		AlphaBlendEnable = false;
        VertexShader = compile vs_3_0 vs_main();
        PixelShader  = compile ps_3_0 ps();
   }
}



////////////////////////////////////////////////////////////////////////////////////////////////////
technique land
{
   pass p0 
   {
				ZEnable = true;
		AlphaBlendEnable = false;
        VertexShader = compile vs_3_0 vs_land();
        PixelShader  = compile ps_3_0 ps();
   }
}



////////////////////////////////////////////////////////////////////////////////////////////////////
technique land_soft_shadow_texture
{
   pass p0 
   {
				ZEnable = false;
		AlphaBlendEnable = false;
        VertexShader = compile vs_3_0 vs_land_soft_shadow_texture();
        PixelShader  = compile ps_3_0 ps_land_soft_shadow_texture();
   }
}

