////////////////////////////////////////////////////////////////////////////////////////////////////
// particles.fx
////////////////////////////////////////////////////////////////////////////////////////////////////



// Transforms
////////////////////////////////////////////////////////////////////////////////////////////////////
float4x4 g_wvp_mtx;
float4x4 g_world_mtx;



// Textures & samplers
////////////////////////////////////////////////////////////////////////////////////////////////////
texture2D g_albedo_tex;

sampler2D g_albedo_samp = sampler_state 
{
		texture = <g_albedo_tex>;
		MaxAnisotropy = 4;
		MinFilter = ANISOTROPIC;
		MagFilter = LINEAR;
		MipFilter = POINT;
		AddressU  = CLAMP;        
		AddressV  = CLAMP;
		AddressW  = CLAMP;
};


// Vertex shaders
////////////////////////////////////////////////////////////////////////////////////////////////////
void vs(
		in float3 iPos : POSITION0,
		in float4 iCol : COLOR,
		in float2 iTc0 : TEXCOORD0,
		
		out float4 oPos	: POSITION,
		out float4 oCol : COLOR,
		out float3 oTc0	: TEXCOORD0 )                                               
{
		// Transform vertex position
		oPos = mul( float4( iPos.xyz, 1.0 ), g_wvp_mtx );
		float4 wPos = mul( float4( iPos.xyz, 1.0 ), g_world_mtx );

		// Copy color
		oCol = iCol;

		// Copy texcoord
		oTc0.xy = iTc0;
		oTc0.z = wPos.y;
}



// Pixel shaders
////////////////////////////////////////////////////////////////////////////////////////////////////
float4 ps( in float4 iCol : COLOR,
		   in float3 iTc0 : TEXCOORD0 ) : COLOR
{
	float4 col = tex2D( g_albedo_samp, iTc0.xy );
	return float4( col.rgb, iCol.a * col.a * saturate( iTc0.z * 0.05 ) );
}



// Techniques
////////////////////////////////////////////////////////////////////////////////////////////////////
technique main
{
   pass p0
   {
		AlphaBlendEnable = True;
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;

        VertexShader = compile vs_3_0 vs();
        PixelShader = compile ps_3_0 ps();
   }
}
