////////////////////////////////////////////////////////////////////////////////////////////////////
// octopod.fx
////////////////////////////////////////////////////////////////////////////////////////////////////



// Transforms
////////////////////////////////////////////////////////////////////////////////////////////////////
float4x4 g_wvp_mtx;
float4x4 g_world_mtx;




// Lighting
////////////////////////////////////////////////////////////////////////////////////////////////////
float4 g_sun_dir;




// Vertex shaders
////////////////////////////////////////////////////////////////////////////////////////////////////
void vs_main(
    in float3 iPos			: POSITION0,
    in float3 iNrm			: NORMAL0,

    out float4 oPos			: POSITION,
    out float3 oNrm			: TEXCOORD0)
{
    // Transform position to clip space
    oPos = mul( float4( iPos.xyz, 1.0 ), g_wvp_mtx );

    // Transform normal to world space
    oNrm = mul( iNrm, (float3x3)g_world_mtx );
}



// Pixel shaders
////////////////////////////////////////////////////////////////////////////////////////////////////
float4 ps_main( in float3 iNrm : TEXCOORD0 ) : COLOR0
{
	float3 n = normalize( iNrm );
	float3 light = 0.5f + ( 0.5f * dot( n, -g_sun_dir ) );

	return float4 (light, 1.0f);
}



// Techniques
////////////////////////////////////////////////////////////////////////////////////////////////////
technique main
{
   pass p0
   {
		ZEnable = true;
		AlphaBlendEnable = false;
		VertexShader = compile vs_3_0 vs_main();
		PixelShader  = compile ps_3_0 ps_main();
   }
}
