
// globals
float4x4 matWorldViewProj;
float fTime;


struct VS_INPUT
{
	vector pos : POSITION;
	float2 tex0 : TEXCOORD0;
};


struct VS_OUTPUT
{
	float4 pos : POSITION;
	float2 tex0 : TEXCOORD0;
};


VS_OUTPUT MainVS(VS_INPUT In)
{
	VS_OUTPUT Out = (VS_OUTPUT)0;

	In.pos.z = In.pos.z + 0.020 * cos(10.0f * In.pos.x - 1.0f * fTime);

	Out.pos = mul(In.pos, matWorldViewProj);

	Out.tex0 = In.tex0;

	return Out;
}


texture2D g_albedo_tex;


// S A M P L E R S
////////////////////////////////////////////////////////////////////////////////////////////////////
sampler2D g_albedo_samp = sampler_state 
{
		texture = <g_albedo_tex>;
		MinFilter = LINEAR;
		MagFilter = POINT;
		MipFilter = POINT;
		AddressU  = WRAP;        
		AddressV  = WRAP;
		AddressW  = WRAP;
};


struct PS_INPUT
{
	float2 tex0 : TEXCOORD0;
};

struct PS_OUTPUT
{
	vector diffuse : COLOR0;
};

PS_OUTPUT MainPS(PS_INPUT In)
{
	PS_OUTPUT Out = (PS_OUTPUT)0;

	vector c0 = tex2D(g_albedo_samp, In.tex0);

	Out.diffuse = c0 * 0.3f;

	return Out;
}

technique main
{
	pass P0
	{
		VertexShader = compile vs_1_1 MainVS();
		PixelShader = compile ps_2_0 MainPS();
	}
}
