#include <conio.h>
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>

typedef unsigned char BYTE;

int LastMode;

BYTE *CurVidMemory = (BYTE*)0xA0000000UL;

BYTE *FlameBuffer1, *FlameBuffer2;

unsigned BufLen;
unsigned BufHgt;
unsigned BufSize;

#define PUTPIXEL(buffer, x, y, pixel) \
buffer[((y) * BufLen) + (x)] = (pixel)

void SetPal( int num, int red, int green, int blue )
{
  outp(0x3C8, num);
  outp(0x3C9, red >> 2);
  outp(0x3C9, green >> 2);
  outp(0x3C9, blue >> 2);
}

void SetPalette( void )
{
  int BLACKRED = 80,
      REDYELLOW = 60,
      YELLOWWHITE = 30;

  int i;

  for (i = 0; i < BLACKRED; i++)
    SetPal(i, i * 255 / (BLACKRED - 1), i * 100 / (BLACKRED - 1), 0);

  for (i = 0; i < REDYELLOW; i++)
    SetPal(i + BLACKRED, 255, i * 155 / (REDYELLOW - 1) + 100, 0);

  for (i = 0; i < YELLOWWHITE; i++)
    SetPal(i + BLACKRED + REDYELLOW, 255, 255, i * 255 / (YELLOWWHITE - 1));

  for (i = BLACKRED + REDYELLOW + YELLOWWHITE; i < 256; i++)
    SetPal(i, 255, 255, 255);
}

void Close( void )
{
  _AX = LastMode;
  geninterrupt(0x10);

  free(FlameBuffer1);
  free(FlameBuffer2);

}

void PlaceHotSpots( void )
{
    int n, o;

    for (n = 0; n < 320; n++)
    {
      o = (rand() % (BufLen - 2)) + 1;

      PUTPIXEL(FlameBuffer2, o, 199, 255);
    }
}

void MoveOldFrameUp( void )
{
  int x, y;
    for (y = 1; y < BufHgt - 1; y++)
      for (x = 1; x < BufLen - 1; x++)
        FlameBuffer1[(y - 1) * BufLen + x] =
          (FlameBuffer2[(y - 1) * BufLen + x - 1] +
           FlameBuffer2[(y - 1) * BufLen + x    ] +
           FlameBuffer2[(y - 1) * BufLen + x + 1] +
           FlameBuffer2[ y      * BufLen + x - 1] +
           FlameBuffer2[ y      * BufLen + x    ] +
           FlameBuffer2[ y      * BufLen + x + 1] +
           FlameBuffer2[(y + 1) * BufLen + x - 1] +
           FlameBuffer2[(y + 1) * BufLen + x    ] +
           FlameBuffer2[(y + 1) * BufLen + x + 1]) / 9;

}
void MoveOldFrameLeft( void )
{
  int x, y;
    for (y = 1; y < BufHgt - 1; y++)
      for (x = 1; x < BufLen - 1; x++)
        FlameBuffer1[y * BufLen + x - 1] =
          (FlameBuffer2[(y - 1) * BufLen + x - 1] +
           FlameBuffer2[(y - 1) * BufLen + x    ] +
           FlameBuffer2[(y - 1) * BufLen + x + 1] +
           FlameBuffer2[ y      * BufLen + x - 1] +
           FlameBuffer2[ y      * BufLen + x    ] +
           FlameBuffer2[ y      * BufLen + x + 1] +
           FlameBuffer2[(y + 1) * BufLen + x - 1] +
           FlameBuffer2[(y + 1) * BufLen + x    ] +
           FlameBuffer2[(y + 1) * BufLen + x + 1]) / 9;

}

void MoveOldFrameRight( void )
{
  int x, y;
    for (y = 1; y < BufHgt - 1; y++)
      for (x = 1; x < BufLen - 1; x++)
        FlameBuffer1[y * BufLen + x + 1] =
          (FlameBuffer2[(y - 1) * BufLen + x - 1] +
           FlameBuffer2[(y - 1) * BufLen + x    ] +
           FlameBuffer2[(y - 1) * BufLen + x + 1] +
           FlameBuffer2[ y      * BufLen + x - 1] +
           FlameBuffer2[ y      * BufLen + x    ] +
           FlameBuffer2[ y      * BufLen + x + 1] +
           FlameBuffer2[(y + 1) * BufLen + x - 1] +
           FlameBuffer2[(y + 1) * BufLen + x    ] +
           FlameBuffer2[(y + 1) * BufLen + x + 1]) / 9;

}

void DrawBuffer( void )
{
  memcpy(CurVidMemory, FlameBuffer1, BufSize - BufLen * 10);

}


int Init( void )
{
  BufLen = 320;
  BufHgt = 200;
  BufSize = BufLen * BufHgt;
  
  _AH = 0x0F;
  geninterrupt(0x10);
  LastMode = _AL;
  _AX = 0x13;
  geninterrupt(0x10);

  if (FlameBuffer1 = malloc(BufSize))
    if (FlameBuffer2 = malloc(BufSize))
      ;
    else
    {
      free(FlameBuffer1);
      return 0;
    }
  else
  {
    return 0;
  }

  memset(FlameBuffer1, 0, BufSize);
  memset(FlameBuffer2, 0, BufSize);

  SetPalette();

  
  return 1;
}

int main ( void )
{
  if (!Init())
    return -1;
  
  while (!kbhit())
  {
    PlaceHotSpots();

    MoveOldFrameUp();

/*
    memcpy(FlameBuffer2, FlameBuffer1, BufSize);
    MoveOldFrameRight();
    memcpy(FlameBuffer2, FlameBuffer1, BufSize);
    MoveOldFrameLeft();
*/

    DrawBuffer();
    memcpy(FlameBuffer2, FlameBuffer1, BufSize);
  }
  
  
  Close();

  return 0;
}


