#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <signal.h>
#include <termios.h>

#ifdef OPENBSD
 #include <sys/audioio.h>
#endif

#ifdef LINUX
 #include <fcntl.h>
 #include <sys/soundcard.h>
#endif

#include "decrunch.h"
#include "beer_song.h"

#include "ascii.h"

#include "font.h"

#define TXT_W 	49
#define TXT_H	14


#define TEST_BIT(x,y)   ((x>>y)&1)
#define SET_BIT(x,y)    (x|(1<<y))

#define LOOP_SIZE	(SPACE * 16)

#define FRAME_PER	4096	

#define GFX_W	(TXT_W*4)
#define GFX_H	(TXT_H*4)

typedef struct {
 int x, y;
} point_t;

point_t line_buf[GFX_W * GFX_H * 2] = { 0 };
unsigned char jbuf[TXT_W * TXT_H *2];

int beer_on_wall = 99;

int flange_seed = 1337;
int reso_seed = 333;
int mad_seed =  366;
int delay_seed = 99;
int delay2_seed = 98;

short rnd(int *seed) {
 return ((*seed = *seed * 214013L + 2521011L)>>16)&0x7fff;
}

char beer_people[][15] = {
 "Metoikos",
 "Dr. Claw",
 "Jason Scott",
 "Luis",
 "Phoenix",
 "Coda",
 "Trixter",
 "Inspired Chaos",
 "GuyBrush",
 "nrr",
 "Andr00",
 "Blackpawn",
 "Polaris",
 "BarZoule",
 "Backlight",
 "s_tec",
 "Nezbie",
 "gd",
 "Mad Brain",
 "Necros",
 "Virt",
 "Circuit Girl",
 "Fat Man",
 "Froggy",
 "Tyger",
 "mrb",
 "Lapine",
 "EvoFlash",
 "Spinsane",
 "Micksam7",
 "The Finn",
 "Beek",
 "LadyMace",
 "Gargaj",
 "Decipher",
 "Tweakt",
 "Voom",
 "Xaimus",
 "Yesso",
 "Overcoat",
 "Ubik",
 "Ivy",
 "LiraNuna",
 "Yesso",
 "cerror",
 "Cerulean",
 "Chin Chin",
 "D-Range",
 "Fat Rat",
 "Floss",
 "Frost",
 "Future Assassin",
 "GooRoo",
 "Grubwerm",
 "h0l",
 "ix",
 "Lord Jazz",
 "Meg",
 "Mikie",
 "Napkin",
 "Nado",
 "RV",
 "Sonic",
 "Adya",
 "Catbones",
 "Fluctuate",
 "Lion GV",
 "LK",
 "Mainline",
 "Shinobi",
 "Sara",
 "Tabaqui",
 "Vengeance",
 "Smeghead",
 "Snowman",
 "Laserlore",
 "Legalize",
 "Nullsleep",
 "Patrick Groove",
 "Anix",
 "b0b",
 "Boomer",
 "Boggart",
 "Coldblood",
 "Dynabyte",

 "Esteban",
 "Grimace",
 "Grey Cat",
 "Jester",
 "Kosh",
 
 "LakEEE",
 "Matryx",
 "Midnight",
 "MrData",
 "Okeanos",
 
 "Picman",
 "Porus",
 "Psykosi",
 "Rao",
 "Scooter"
};

FILE *audp;

unsigned int pos=0;

float loop[SPACE * 64];

#define DELAY (SPACE/16)
#define REGEN 0.75f;
float delay[DELAY];

#define DELAY2 (SPACE*4)
#define REGEN2 0.45f;
float delay2[DELAY2];

#define DELAY3 (SPACE*2)
#define REGEN3 0.45f;
float delay3[DELAY3];


unsigned char wav_header[] = {
 0x52, 0x49, 0x46, 0x46, 0x24, 0xa0, 0xaf, 0x07,
 0x57, 0x41, 0x56, 0x45, 0x66, 0x6d, 0x74, 0x20,
 0x10, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x00,
 0x44, 0xac, 0x00, 0x00, 0x10, 0xb1, 0x02, 0x00,
 0x04, 0x00, 0x10, 0x00, 0x64, 0x61, 0x74, 0x61,
 0x00, 0xa0, 0xaf, 0x07,
};

int mods[20] = {0};

float loop_delay[LOOP_SIZE * 2];
int loop_frame= 0;



float D1=0.0f, D2=0.0f, fil_f, fil_q;
float reso(float in, float mod) {
 float rmod;
 if(mod>1.0f)
  rmod = mod-1.0f;
 else
  rmod = mod;
 float f = fil_f * rmod;
 float out = D2 + f * D1;
 float hpout = in-out-(fil_q*D1);
 D1 = f * hpout + D1;
 D2 = out;
 if(mod > 1.0f) 
  return hpout;
 else
  return out;
}

int mod_pos(int fin) {
 int pool = 0;
 int ret,i, in;

 double r, r2;
 r = (float)fin / (float)LOOP_SIZE;
 in = (int)((float)0xffff * r);

 ret = in;
 for(i=0;i<16;i++)
  if(mods[i] == 1)
   if(TEST_BIT(ret,i)==1)
    pool = 1;
 for(i=0;i<16;i++) 
  if(mods[i] == 1 && pool == 1)
   ret = SET_BIT(ret,i);
 if(mods[17] == 1 && pool == 1)
  ret = 0;

 r2 = (float)ret / (float)0xffff;
 
 return (int)(r2 * (float)LOOP_SIZE);
}

const char noise[]= { "*.+-" };

unsigned char txt_store[TXT_W * TXT_H *2] = { 0 };
//unsigned char txt[TXT_W * TXT_H];
unsigned char *txt;

unsigned char over[TXT_W * TXT_H] = { 0 };

int draw_frame_num = 0;

void draw_frame(void) {
 int x,y,j;
 printf("\33[u\33[4C\33[2B");
 j=0;
/*
 for(y=0;y<TXT_H;y++){
  j = 0;
  for(x=0;x<TXT_W;x++)
   if(txt[x+(y*TXT_W)] != txt[(x+(y*TXT_W))+(TXT_W*TXT_H)]) {
    j = 1;
    break;
   }
  if(j==1) {
   for(x=0;x<TXT_W;x++)
    putchar(txt[(x+(y*TXT_W))+((TXT_W*TXT_H)*draw_frame_num)]);
  } else
    printf("\33[%dC", TXT_W);
  printf("\33[B\33[%dD",TXT_W);
 }
 */

 // it actually looks smoother drawing all characters 
 for(y=0;y<TXT_H;y++) {
  for(x=0;x<TXT_W;x++) {
   putchar(txt[j]);
   j++;
  }
  printf("\33[B\33[%dD", TXT_W);
 }
// draw_frame_num^=1;
// txt = &txt_store[(TXT_W*TXT_H)*draw_frame_num];
}

enum {
 FUZZ,
 INTRO1,
 BEER,
 SIL
};

int channel = SIL;
int intro_clk = 0;

unsigned char chans[] = { "|/-" };
int ichans = 0;

#define PLUS_CHAN \
 printf("\33[u\33[58C\33[8B%c", chans[ichans++]); 

int back_q = 0;

void fuzz(void) {
 int j;
 int x,y;
 unsigned char dat;
 switch(channel) {
  case FUZZ:
   for(j=0;j<TXT_W*TXT_H;j++)
    txt[j] = noise[random()%4];
   break;
  case INTRO1:
   j = 0;
   for(y=0;y<TXT_H;y++) 
    for(x=0;x<TXT_W;x++) {
     dat = bio_back[((x + back_q)%16) + (((y+back_q)%8)*16)];
     txt[j++] = dat;
    }
   back_q++;
   j=0;
   for(y=0;y<8;y++)
    for(x=0;x<37;x++) {
     dat = message[j++];
     txt[(x+7) + ((y+3)*TXT_W)] = dat;
    }
   break;
 }
}

unsigned char suds[10 * TXT_H] = { 32 };

unsigned char sud[] = { "Oo.        " };

void tick_suds(void) {
 int i;
 int x,y;
 for(i=0;i<10;i++) 
  suds[i+ (10*(TXT_H-1))] = sud[ random()%11];
 for(y= 0;y<(TXT_H-1);y++) 
  for(x = 0;x<10;x++) 
   suds[x+ (y*10)] = suds[x+((y+1)*10)];
}

unsigned char replace[] = { "0123456789" };

int beer_frame = 0;

void draw_suds(void) {
 int x, y, j;
 if((beer_frame%10)==0)
  tick_suds();
 for(y=0;y<TXT_H;y++) 
  for(x=0;x<TXT_W;x++) {
   for(j =0;j<10;j++)
    if(txt[x+(y*TXT_W)]==replace[j]) 
     txt[x+(y*TXT_W)] = suds[ j+ (y*10)];

  }
}

void blit(img_t *in, int px, int py) {
 int x,y;
 for(y=0;y<in->h;y++)
  for(x=0;x<in->w;x++) {
   if(((px+x) >=0 ) &&
      ((px+x) < TXT_W) &&
      ((py+y) >=0 ) &&
      ((py+y) < TXT_H)) {
    if(in->dat[x+(y*in->w)] != '!') 
     txt[ (px+x) + ((py+y)*TXT_W)] = in->dat[x+(y*in->w)];
   }
  }
}

int wall_shift;

void line(int x1, int y1, int x2, int y2);

char match(int k) {
 int i, q;
 int A,B;
 int level, m_level;
 char m_char; 
 A = jbuf[(k*2)];
 B = jbuf[(k*2)+1];
 if((A+B) == 0) {
  m_char = ' ';
  goto match_done;
 }
 m_level = 0;

 for(i = 0;i<95;i++) {
  level = 0;
  for(q = 0;q < 8;q++) {
   if( ((A>>q)&1)==((font_data[i*2  ]>>q)&1) )
    level++;
   if( ((B>>q)&1)==((font_data[(i*2)+1]>>q)&1) ) 
    level++;
  }
  if(level > m_level) {
   m_level = level;
   m_char = i+32;
  }
 }
   
 match_done:
  return m_char;
}

int phrase = 0;

void beer_draw() {
 float q;
 int i, j;
 int x,y;
 char buf[33];
 int beer_num;
 unsigned char dat;
 beer_num = pos/(LOOP_SIZE * 4);
 if((pos%(LOOP_SIZE*8))==0) wall_shift = random()%10;
 q = (float)(pos%(LOOP_SIZE*2))/ (float)(LOOP_SIZE*2);
 if((pos%(LOOP_SIZE*4))< ((LOOP_SIZE*4)/2)) {
  for(j=0;j<TXT_W*TXT_H;j++) 
   txt[j] = smile_back[(((j%TXT_W) + (beer_frame>>2))%16) + 
                     ((((j/TXT_W)+(beer_frame>>2))%8)*16)];

  if(q<=0.5f) {
   if((beer_num&1)==0) {
    blit(&hand_img, TXT_W- (sin(q*(3.141592))*17), 0);
    if(beer_num != 98)
     blit(&beer_img, -4,0);
    blit(&beer_img, 18,0);
   } else {
    blit(&hand_img, TXT_W- (sin(q*(3.141592))*39), 0-(cos(q*3.141592)*2));
    blit(&beer_img, -4,0);

   }
  } else {
   if((beer_num&1)==0) {
    if(beer_num!=98)
     blit(&beer_img, -4,0);
    blit(&beer_hand_img, (TXT_W- (sin(q*(3.141592))*17))-12, 0);
   } else {
    blit(&beer_hand_img, (TXT_W- (sin(q*(3.141592))*39))-12, 0);

   }
  }
  draw_suds();
  blit(&the_wall_img, -wall_shift,TXT_H-3);
 } else {
  bzero(jbuf, TXT_W*TXT_H*2);
  for(j = 0;j<30;j++) {
   line(GFX_W/2, GFX_H/2, (GFX_W/2) + cos((j*((2*3.141592)/30.0f))+q)*(GFX_W/2),
                          (GFX_H/2) + sin((j*((2*3.141592)/30.0f))+q)*(GFX_W/2));
  }
  for(j=0;j<TXT_W*TXT_H;j++) 
   txt[j] = match(j);
  blit(&cir_img, (TXT_W/2)-5,(TXT_H/2)-6);
  j = 0;
  for(y=0;y<3;y++)
   for(x=0;x<37;x++) {
    dat = beer_message[j++];
    txt[(x+7) + ((y+11)*TXT_W)] = dat;
   }
  i = (10.0f / (q*10.0f));
  blit(&beer_hand2_img,1-(i+7),0); 
  draw_suds();
  snprintf(buf, 33, "This beer is for %s", beer_people[beer_num]);
  i = strlen(buf);
  for(j=0;j<i;j++)
   txt[((25+j) + (12*TXT_W))-(i/2)] = buf[j];
 }
 beer_frame++;
}

void overlay(void) {
 int j;
 for(j=0;j<TXT_W*TXT_H;j++)
  if(over[j]!=0)
   txt[j] = over[j];
}

void intro_lump(void) {
 int i;
 float acum;
 signed short data;
 unsigned char dat1, dat2;
 for(i = 0; i< 1024;i++) {
  switch(channel) {
   case SIL:
    acum = 0.0f;
    break;
   case FUZZ:
    acum = (float)(random()&0xffff)/(float)0xffff;
    break;
   case INTRO1:
    acum = cos(((float)intro_clk/50.0f)+ (cos((float)intro_clk/900.0f)*2.0f));
    break;
  }
  intro_clk++;
  if(acum > 1.2f)
   acum = 1.2f;
  if(acum < -1.2f)
   acum = -1.2f;
  data = acum * 20000;
  dat1 = data&0xff;
  dat2 = (data&0xff00)>>8;
  write(fileno(audp), &dat1, 1);
  write(fileno(audp), &dat2, 1);
  write(fileno(audp), &dat1, 1);
  write(fileno(audp), &dat2, 1);

/*
  fputc(data&0xff, audp);
  fputc((data&0xff00)>>8, audp);
  fputc(data&0xff, audp);
  fputc((data&0xff00)>>8, audp);
  */
 }
 fflush(audp);
}

void end_game(int in);

void check_escape(void) {
 unsigned char dat;
 if((read(fileno(stdin),&dat, 1)) ==1 )
  if(dat=='\33') end_game(0);
}

void intro(void) {
 int to_intro[3] = { 0 };
 int i, q,x,y, lumpers=0;
 for(i=0;i<TV_H;i++)
  printf("\n\33[K");
 printf("\33[%dA\33[s", TV_H);
 fflush(stdout);
 lumpers = 1;
 for(q=0;;q++) {
  if(q>291) {
   if(q==292)
    channel = FUZZ;
   lumpers = 1;
   if(q>=293 && q<=309) {
    over[ (tv_order[q][0] -5) + ((tv_order[q][1]-3)*TXT_W)] = 
     tv[(tv_order[q][0]-1) + ((tv_order[q][1]-1)*TV_W)];
   }
   fuzz();
   overlay();
   draw_frame();
  }
  if(tv_order[q][0] == 0xff) break;
  printf("\33[u");
  if(tv_order[q][0] != 1) 
   printf("\33[%dC", tv_order[q][0]-1);
  if(tv_order[q][1] != 1) 
   printf("\33[%dB", tv_order[q][1]-1);

  putchar(tv[(tv_order[q][0]-1) + ((tv_order[q][1]-1)*TV_W)]);
  fflush(stdout);
  if(lumpers == 1)
   intro_lump(); 
#ifdef OPENBSD
  usleep(20); 
#endif
  check_escape();

 }
 for(;;) {
  fuzz();
  overlay();
  draw_frame();
  check_escape();
  fflush(stdout);
  intro_lump();
  if((intro_clk > (int)(44100.0f * 5.0f)) && to_intro[0]==0) {
   to_intro[0] = 1;
   channel = INTRO1;
   PLUS_CHAN;
  } 

  if((intro_clk > (int)(44100.0f * 16.0f)) && to_intro[1]==0) {
   to_intro[1] = 1;
   channel = FUZZ;
   PLUS_CHAN;
  } 

  if((intro_clk > (int)(44100.0f * 16.5f)) && to_intro[2]==0) {
   PLUS_CHAN;
   break;
  } 

#ifdef OPENBSD
  usleep(20);
#endif
 }
}

tcflag_t old_lflag;

void end_game(int in) {
 int i;
 struct termios ios;
 printf("\33[u");
 for(i=0;i<TV_H;i++)
  printf("\33[K\n");
 printf("\33[u");
 if(pos!=-1)
  printf(":C\n");
 else
  printf("Holy-Shit!!! I can't believe you watched the whole thing!!\n");
 fflush(stdout);
 tcgetattr(fileno(stdin), &ios);
 ios.c_lflag = old_lflag;
 tcsetattr(fileno(stdin), TCSANOW, &ios);

 exit(0);
}


int main(int argc, char **argv) {
 float acum, beer;
 char *name;
 int i, j;
 struct termios ios;
 int to_wave = 0;

 unsigned char dat1, dat2;
 unsigned int flange_song;
 unsigned int reso_song;
 unsigned int delay_song;
 unsigned int delay2_song;
 unsigned int mad_song = 64;

 unsigned int pos2, pos3;

 signed short data;
#ifdef OPENBSD
 audio_info_t req, get;
 name = "/dev/audio";
#endif
#ifdef LINUX
 audio_buf_info buf_info;
 int format, channels, rate, fragspec;
 name = "/dev/dsp";
#endif

 if(argc>1)
  if(strcmp(argv[1], "-d")==0) {
   printf("Passing beer to beer.wav\n");
   if((audp = fopen("beer.wav", "w"))<=0) {
    perror("beer.wav");
    exit(-1);
   }
   fwrite(wav_header, 1, 44, audp);
   to_wave = 1;
  }
 
 if(to_wave == 0) {
  if((audp=fopen(name, "w"))<=0) {
   perror(name);
   exit(-1);
  } 

#ifdef OPENBSD
  AUDIO_INITINFO(&req);
  req.mode= AUMODE_PLAY;
  req.play.sample_rate = 44100;
  req.play.channels = 2;
  req.play.precision = 16;
  req.play.encoding = AUDIO_ENCODING_SLINEAR_LE;
  if(ioctl(fileno(audp), AUDIO_SETINFO, &req)<0) {
   printf("Can't set ioctl for %s\n", name);
   exit(-1);
  }
  ioctl(fileno(audp), AUDIO_GETINFO, &get);
  if(req.play.sample_rate != get.play.sample_rate ||
     req.play.channels !=    get.play.channels    ||
     req.play.precision !=   get.play.precision   ||
     req.play.encoding  !=   get.play.encoding) {
   printf("Can't get proper playback mode for %s\n", name);
   exit(-1);
  }
#endif

#ifdef LINUX
  format = AFMT_S16_LE;
  rate = 44100;
  channels = 2;
  if( ioctl(fileno(audp), SNDCTL_DSP_SETFMT, &format) == -1 ||
      ioctl(fileno(audp), SNDCTL_DSP_SPEED, &rate)    == -1 ||
      ioctl(fileno(audp), SNDCTL_DSP_STEREO, &channels)==-1 ){
   printf("couldn't set proper mode for %s\n", name);
   exit(-1);
  } else
   if(format != AFMT_S16_LE ||
      channels!=1) {
    printf("couldn't get proper playback for %s\n", name);
    exit(-1);
   }
 ioctl(fileno(audp), SNDCTL_DSP_GETOSPACE, &buf_info);
 if(buf_info.fragsize >= 32768) 
  printf("you have a big fragment size, audio might be delayed\n");
 fragspec = 0x00080000 | (buf_info.fragsize&0xffff);
 if(ioctl(fileno(audp), SNDCTL_DSP_SETFRAGMENT, &fragspec) == -1) { 
  printf("can't set fragments\n");
  exit(-1);
 } 

#endif
 }
// fcntl(fileno(audp),F_SETFL, fcntl(fileno(audp),F_GETFL,0)|O_SYNC);
 decrunch();

 signal(SIGQUIT, end_game);
 signal(SIGABRT, end_game);
 signal(SIGINT,  end_game);
 signal(SIGTERM, end_game);
 signal(SIGKILL, end_game);

 fcntl(fileno(stdin),F_SETFL, fcntl(fileno(stdin),F_GETFL,0)|O_NONBLOCK);
 tcgetattr(fileno(stdin), &ios);
 old_lflag = ios.c_lflag;
 ios.c_lflag &= ~ICANON;
 ios.c_lflag &= ~ECHO;
 tcsetattr(fileno(stdin), TCSANOW, &ios);

 txt = txt_store;

 for(i=0;i<TXT_H;i++)
  tick_suds();
 intro();

 for(i=0;i< (SPACE * 64);i++) {
  acum = 0.0f;

  if(trk[(i/SPACE) * 2].note != N)
   trigger( trk[(i/SPACE) *2].note-1,&samples[trk[(i/SPACE) *2].sam -1]); 

  if(trk[((i/SPACE) * 2)+1].note != N)
   trigger(0,&samples[3]); 

  for(j=0;j<5;j++)
   acum+=pull(&samples[j]);
  loop[i] = acum;
 }

 for(i=0;i<DELAY;i++)
  delay[i] = 0.0f;

 fil_f = 1.0f;
 fil_q = 1.4f;


 for(;;pos++) {
  pos3 = pos - (pos%LOOP_SIZE);
  pos2 = pos3+mod_pos(pos%LOOP_SIZE);

  acum = loop[(pos2 % (SPACE *64))];
  delay[pos%DELAY] = acum + delay[ pos%DELAY] * REGEN;
  delay2[pos%DELAY2] = acum + delay2[ pos%DELAY2] * REGEN2;
  delay3[pos%DELAY3] = acum + delay3[ pos%DELAY3] * REGEN3;


  if((pos%(SPACE)) == 0) flange_song = rnd(&flange_seed);
  if((flange_song&3) ==0) 
   acum+=delay[(pos+1)%DELAY];

  if((pos%(SPACE*16)) == 0) delay_song = rnd(&delay_seed);
  if((delay_song&3) ==0) 
   acum+=delay2[(pos+1)%DELAY2];

  if((pos%(SPACE*16)) == 0) delay2_song = rnd(&delay2_seed);
  if((delay2_song&7) ==0) 
   acum+=delay3[(pos+1)%DELAY3];



  if((pos % (SPACE *64)) == 0) { 
   fix(0, beer_on_wall);
   fix(1, beer_on_wall--);
   fix(2, beer_on_wall);
   if(beer_on_wall == -1) {
    pos = -1;
    end_game(0);
   }
   trigger(0, &samples[0]);
  }
  beer = pull(&samples[0]) *1.5f;

  if((pos%(SPACE*32))==0) reso_song = rnd(&reso_seed);
  if((reso_seed&7)==0)
   acum+=reso(beer, fabs(2.0f * sin((float)pos / 40000.0f)));
  else
   acum+=beer;


  if((pos%(SPACE * mad_song)) == 0) {
   bzero(mods, 20*sizeof(int));
   mods[rnd((&mad_seed)+4)%20] =1;
   mods[rnd((&mad_seed)+4)%20] =1;
   mad_song = (rnd(&mad_seed)%64)+1;
  }

  loop_delay[(pos%LOOP_SIZE)+ (LOOP_SIZE*(loop_frame&1)) ] = acum;
  if((pos%LOOP_SIZE)==(LOOP_SIZE-1)) loop_frame^=1;

 

  if(acum > 1.2f)
   acum = 1.2f;
  if(acum < -1.2f)
   acum = -1.2f;
  data = acum * 20000;
  dat1 = data&0xff;
  dat2 = (data&0xff00)>>8;
  write(fileno(audp), &dat1, 1);
  write(fileno(audp), &dat2, 1);
  write(fileno(audp), &dat1, 1);
  write(fileno(audp), &dat2, 1);
/*
  fputc(data&0xff, audp);
  fputc((data&0xff00)>>8, audp);
  fputc(data&0xff, audp);
  fputc((data&0xff00)>>8, audp);
*/
  if((pos % (FRAME_PER/2))==0) {
   beer_draw();
   overlay();
   draw_frame();
   check_escape();
   fflush(audp);
   fflush(stdout);
#ifdef OPENBSD
   usleep(10);
#endif
  }

 }
}

void line(int x1, int y1, int x2, int y2) {
  int dx = (x1 <= x2) ? x2 - x1 : x1 - x2;
  int dy = (y1 <= y2) ? y2 - y1 : y1 - y2;
  int x  = x1;
  int y  = y1;
  int e  = 0;
  int k;
  int xInc = (x1 <= x2) ? 1 : -1;

  int shift; 
  int jbuf_pos;
  int point_num, i;

  unsigned char *pix;
  if(x1 == x2 && y1 == y2) return;

  point_num =0;

#define POINT(x,y) { \
 if(x>0 && x<GFX_W && y>0 && y<GFX_H) \
  line_buf[point_num  ].x = x; \
  line_buf[point_num++].y = y; \
} 
  if(x1 == x2)
    xInc = 0;
  int yInc = (y1 <= y2) ? 1 : -1;
  if(y1 == y2)
    yInc = 0;
  if(dy <= dx) {
    for( ; (xInc*x <= xInc*x2) && (yInc*y <= yInc*y2); x += xInc ) {
     POINT(x,y)
      e += dy;
      if( yInc && (2*e + yInc*dy) >= xInc*dx ) {
        y += yInc;
        e -= dx;
      }
    }
  }
  else {
    for( ; (yInc*y <= yInc*y2) && (xInc*x <= xInc*x2); y += yInc ) {
     POINT(x,y)
      e += dx;
      if( xInc && (2*e + xInc*dx) >= yInc*dy ) {
        x += xInc;
        e -= dy;
      }
    }
  }
/* convert line_buf */
 for(i = 0; i<point_num;i++) 
#define SET_JBUF(x,y) \
 jbuf[((((x/4) + ((y/4)*TXT_W)))*2)+((y%4)/2)] = \
  SET_BIT(jbuf[((((x/4) + ((y/4)*TXT_W)))*2)+(y%4)/2 ], (((y%2)^1) * 4) + (3-(x%4)));
  if(line_buf[i].x > 0 && line_buf[i].x < GFX_W &&
     line_buf[i].y > 0 && line_buf[i].y < GFX_H) {
   SET_JBUF( (line_buf[i].x), (line_buf[i].y) )
 }
}

