#include <stdio.h>
#include <stdlib.h>

typedef struct {
 int pos, len;
} num_t;

#include "samples.h"
#include "numbers.h"
#include "teens.h"

#include <mad.h>

#include "decrunch.h"

unsigned short *store;
int total;

sample_t samples[6];

sample_t numbers;
sample_t zero;
sample_t teens;


struct buffer {
 unsigned char *start;
 unsigned int length;
};

const float freq_tab[2] = { 1.0f, 1.12f };

float pull(sample_t *in) {
 float ret;
 if(in->pos == -1.0f) return 0.0f;
 ret = in->data[(int)in->pos];
 in->pos += in->speed;
 if(in->pos > (float)in->len)
  in->pos = -1.0f; 
 return ret;
}

void trigger(int note, sample_t *in) {
 in->pos = 0.0f;
 in->speed = freq_tab[note];
}

enum mad_flow input(void *data, struct mad_stream *stream) {
 struct buffer *buffer = data;
 if(!buffer->length)
  return MAD_FLOW_STOP;
 mad_stream_buffer(stream, buffer->start, buffer->length);
 buffer->length = 0;
 return MAD_FLOW_CONTINUE;
}

unsigned short scale(mad_fixed_t sample) {
 sample+=(1L << (MAD_F_FRACBITS - 16));
 if(sample>=MAD_F_ONE)
  sample = MAD_F_ONE - 1;
 else if(sample < -MAD_F_ONE) 
  sample = -MAD_F_ONE;
 return sample >> (MAD_F_FRACBITS +1 - 16);
}

enum mad_flow output(void *data, struct mad_header *header, struct mad_pcm *pcm) {
 unsigned int nchannels, nsamples;
 mad_fixed_t *left_ch, *right_ch;
 signed int sample;
 nchannels = pcm->channels;
 nsamples = pcm->length;
 left_ch = pcm->samples[0];
 right_ch =pcm->samples[1];
 while(nsamples--) 
  store[total++] = scale(*left_ch++);

 return MAD_FLOW_CONTINUE;
}

void to_float(unsigned short *in, int len, float *out) {
 int i;
 signed short dat;
 for(i = 0;i<len;i++) {
  dat = (signed short)in[i];
  out[i] = (float)dat/20000;
 }
}

void decode(unsigned char *start, unsigned int len, sample_t *out) {
 struct buffer buffer;
 struct mad_decoder decoder;

 buffer.start = start;
 buffer.length = len;
 total = 0;
 
 mad_decoder_init(&decoder, &buffer, input, 0, 0, output,0 , 0);
 mad_decoder_run(&decoder, MAD_DECODER_MODE_SYNC);
 mad_decoder_finish(&decoder);

 out->data = (float *)malloc(sizeof(float)*total);
 to_float(store, total, out->data);
 out->len = total;
 out->pos = -1.0f;
}




void decrunch(void) {
 store = (signed short *)malloc(sizeof(signed short) * 6000000);

 decode(sam_1_mp3, MP3_1_LEN, &samples[0]);
 decode(sam_2_mp3, MP3_2_LEN, &samples[1]);
 decode(sam_3_mp3, MP3_3_LEN, &samples[2]);
 decode(sam_4_mp3, MP3_4_LEN, &samples[3]);
 decode(sam_5_mp3, MP3_5_LEN, &samples[4]);
 decode(numbers_mp3, NUMBERS_LEN, &numbers);
 decode(zero_mp3, ZERO_LEN, &zero);
 decode(teens_mp3, TEENS_LEN, &teens);

 free(store);
}

void fix(int reg, int in) {
 int i,j,k;
 float q;
 int h,l;

 h = (in / 10) -1;
 l = (in % 10) -1;

 for(i=0;i<regions[reg].len;i++)
  samples[0].data[regions[reg].pos+i] = 0.0f;

 if(in == 0) {
  k = 0;
  for(i = 0;i< regions[reg].len;i++) {
   if(k<=zero.len)
    samples[0].data[regions[reg].pos+i] = zero.data[k++]*1.5f;
  }
  return;
 }

 if((in < 20) && (in > 10)) {
  k = 0; 
  h = in  - 11;
  for(i = 0;i< regions[reg].len;i++) {
   if(k<=teen_regs[h].len)
    samples[0].data[regions[reg].pos+i] = teens.data[teen_regs[h].pos + k++];
  }

  return;
 }

 if( h != -1) {
  k = 0;
  for(i = 0;i< regions[reg].len;i++) {
   if(k<=hi_num[h].len)
    samples[0].data[regions[reg].pos+i] = numbers.data[hi_num[h].pos+k++]*1.5f;
  }
 } else {
  k = 0;
  for(i = 0;i< regions[reg].len;i++) {
   if(k<=lo_num[l].len)
    samples[0].data[regions[reg].pos+i] = numbers.data[lo_num[l].pos+k++]*1.5f;
  }
  return;
 }

 if(l != -1) {
  k = 0;
  for(i = regions[reg].len/2;i< regions[reg].len;i++) {
   if(k<=lo_num[l].len)
    samples[0].data[regions[reg].pos+i] = numbers.data[lo_num[l].pos+k++]*1.5f;
  }
 }

}


