/*

 Name      :  Unlimited Sprites
 Notes     :  http://luis.net/projects/processing/sprites/ 
 
 An infinate number of sprites drawn to screen. It's basically a flick-book effect;
 you draw the same sprite in different positions on different bufffer 'screens' and flip between them. 
 When you've drawn on all frames, you loop back to the beginning and repeat 
 
 */

void sprites(int w,int h){  
  float xang = 0.0;
  float yang = 0.0;
  byte page = 0;                       // double buffer counter
  int half_w = w/2;
  int half_h = h/2;

  unsigned int timeDisplacement=1300;  // number of frames to run
  do  
  {
    for (byte i = 0; i <150; i++)
    {
      vgm();
    }   
    // Get X, Y positions
    float x = half_w*fpu_sin(radians(xang)*0.95);
    vgm();
    float y = half_h*fpu_cos(radians(yang)*0.97);
    vgm();
    // Inc the angle of the sine
    xang += 1.17;
    yang += 1.39;
    switchWritePage(page);
    vgm();
    drawBall( x+half_w+113,y+half_h+74,5, color(255,0,0)); // outer ball
    vgm();
    drawBall( x+half_w+113,y+half_h+74,4, color(0,255,0)); // inner ball
    vgm();
    switchViewPage(page);    // Blit the active surface to the screen
    vgm();
    page = (page+1) % 6;     // Inc the active surface number
  }  
  while(--timeDisplacement);
}



