/*

 Name      :  Introduction Sequence
 Notes     :  Build Anticipation
 
 Introduce the hardware.  Play FM music.  Load monitor image.
 
 */

void intro(){
  loadImage(106,88,98,34,"O 2R>sega.vga\r");  // load sega logo
  delayMicro(1000);                           // wait one second for nostalgia to sink in
  loadVGM("O 1R>start.vgm\r");                // load startup sound
  play(2000);                                 // lets hear it
  silence();                                  // 
  delayMicro(2000);                           // look at the logo some more
  loadVGM("O 1R>INTRO.VGM\r");                // preload intro music 

  byte green = color(0,255,0);

  rect(92,38,285,167,0);
  text(10, 10, 2, 2, 2, green,          "Duino Demo      ");
  text(10, 10+28, 2, 2, 2, green,       "@ Party 2010    ");

  play(5000);

  text(10, 10, 2, 2, 2, green,          "CPU:            ");
  text(10, 10+28, 2, 2, 2, green,       "Arduino Nano    ");
  text(10, 10+28+28, 2, 2, 2, green,    "8-Bit ATMEGA328 ");
  text(10, 10+28+28+28, 2, 2, 2, green, "2K RAM          "); 

  play(5000);

  text(10, 10, 2, 2, 2, green,          "SOUND:          ");
  text(10, 10+28, 2, 2, 2, green,       "YM2612 FM       ");
  text(10, 10+28+28, 2, 2, 2, green,    "SN76489 PSG     ");
  text(10, 10+28+28+28, 2, 2, 2, green, "VGM 1.5 Spec    "); 

  play(5000);    

  text(10, 10, 2, 2, 2, green,          "VIDEO:          ");
  text(10, 10+28, 2, 2, 2, green,       "4D Systems      ");
  text(10, 10+28+28, 2, 2, 2, green,    "uVGA MD 1       ");
  text(10, 10+28+28+28, 2, 2, 2, green, "256 color QVGA  "); 

  play(5000);    

  text(10, 10, 2, 2, 2, green,          "Its DEMO time!  ");
  text(10, 10+28, 2, 2, 2, green,       "                ");
  text(10, 10+28+28, 2, 2, 2, green,    "                ");
  text(10, 10+28+28+28, 2, 2, 2, green, "                "); 

  play(4000);

  silence();
  writeFM(B00000000, B000011);                                  // reset YM2612
  text(10, 10, 2, 2, 2, green,          "                ");    // clear its demo time
  rect(0,38,310,167,255);                                       // draw white box  
  loadImage(100, 58, 110, 93, "O 2R>monitor.vga\r");            // load mini-monitor 

  // copy the monitor image to all pages of video memory (3-7 needed for unlimited sprites effect)
  copyPage(0,0,0,0, 310, 210, 0, 1);
  copyPage(0,0,0,0, 310, 210, 0, 2);
  copyPage(0,0,0,0, 310, 210, 0, 3);
  copyPage(0,0,0,0, 310, 210, 0, 4);
  copyPage(0,0,0,0, 310, 210, 0, 5);
  copyPage(0,0,0,0, 310, 210, 0, 6);
  copyPage(0,0,0,0, 310, 210, 0, 7);
  loadVGM("O 1R>missing.VGM\r");                               // load music that will play for most of demo
}


