/*

 Name        : Duino Demo                                        
 Author      : Luis Gonzalez - lobster@luis.net
 Date        : 12 May, 2010                                      
 Version     : 1.0                                               
 Platform    : Arduino Nano - Atmel ATMEGA368                                   
 Environment : Arduino 0018                                      
 Notes       : Old-school demoscene effects with VGM music playback
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA 
 
 */

#include "vgm.h"             // sound
#include <avr/pgmspace.h>    // use program flash space as storage
#include "fpu.h"             // math

#define SCK_PIN        13    // SPI Data bus used by four devices
#define MISO_PIN       12
#define MOSI_PIN       11

#define FPU_SS_PIN      4    // CS for FPU
#define VGA_SS_PIN      5    // CS for microVGA (text-mode circuit not used)
#define VGM_SS_PIN      9    // CS for Sound (74HC595)
#define FAT_SS_PIN     10    // CS for ualFat
#define FAT_RESET_PIN   3    // reset for ualfat 

//--- Important: All Pins must be 8 or higher (in PORTB range)
#define VGM_SS_PIN_PORTB    VGM_SS_PIN - 8
#define SCK_PIN_PORTB       SCK_PIN - 8
#define MOSI_PIN_PORTB      MOSI_PIN - 8
#define FAT_SS_PIN_PORTB    FAT_SS_PIN - 8

#define screenPosX    107    // horizontal position of mini-monitor image
#define screenPosY     68    // vertical position of mini-monitor image

byte showSlide=1;            // which part of demo to show first

void setup(){ 
  //set pins to output because they are providing digital on or off
  pinMode(VGA_SS_PIN, OUTPUT);
  pinMode(VGM_SS_PIN, OUTPUT);
  pinMode(FAT_SS_PIN, OUTPUT);
  pinMode(FPU_SS_PIN, OUTPUT); 
  pinMode(SCK_PIN, OUTPUT);
  pinMode(MOSI_PIN, OUTPUT);
  pinMode(MISO_PIN, INPUT); // this pin will read in data from SPI bus
  pinMode(FAT_RESET_PIN, OUTPUT);

  digitalWrite(VGA_SS_PIN,HIGH);
  digitalWrite(VGM_SS_PIN,LOW);
  digitalWrite(FAT_SS_PIN,HIGH);
  digitalWrite(FPU_SS_PIN,HIGH);
  digitalWrite(SCK_PIN,HIGH);
  digitalWrite(MOSI_PIN,LOW);
  digitalWrite(MISO_PIN,LOW);

  init_fpu();        // fire up the math co-processor
  init_fat();        // fire up the file system
  init_vga();        // fire up the video
  init_vgm();        // fire up the sound system 
}

void loop(){  
  switch (showSlide)
  {
  case 1:
    intro();
    break;  
  case 2:
    title(1, "FIRE");
    fire(screenPosX+2, screenPosY+2, 15, 15);
    clearMiniMonitor();
    break;  

  case 3:
    title(1, "ROTOZOOMER");
    rotozoomer(screenPosX+15, screenPosY+10, 65, 45,0);  // xor texture
    rotozoomer(screenPosX+15, screenPosY+10, 65, 45,1);  // bitmap texture
    clearMiniMonitor();
    break;  

  case 4:
    title(1, "METABALL  ");
    metaball(screenPosX,screenPosY,65,45);
    break;  

  case 5:
    title(1, "3D CUBE   ");
    cube();  
    clearMiniMonitor();
    break;  

  case 6: 
    title(5, "UNLIMITED SPRITES");
    sprites(94-12,64-13);
    break;  

  case 7:
    title(1, "VECTORBALL       ");
    vectorball(screenPosX, screenPosY, 94, 64);    
    clearMiniMonitor();
    break;

  case 8:
    // had to cut this out
    // title(1, "PLANE DEFORMATION");
    // deform(92, 38, 32, 32,8); 
    break;  

  case 9:  
    title(1, "PLASMA           ");
    plasma(screenPosX, screenPosY, 94, 64);
    switchWritePage(0);
    switchViewPage(0);
    break;  

  case 10: 
    silence();
    clearMiniMonitor();
    title(1, "VGM PLAYBACK");
    loadImage(screenPosX, screenPosY, 94, 64, "O 2R>thunderforce_small.vga\r"); 
    loadVGM("O 1R>TF4.VGM\r");  
    play(28000);
    silence();
    break;  

  case 11:
    clearScreen();  
    silence();
    title(1, "      THE END  ");
    rect(0,38,310,167,0); // white box  
    text(screenPosX-30, screenPosY, 1, 1, 0, color(0,255,0),          "Code & Hardware Assembly:");
    text(screenPosX-30, screenPosY+14, 1, 1, 0, color(0,255,0),       "  Luis Gonzalez");
    text(screenPosX-30, screenPosY+14+14, 1, 1, 0, color(0,255,0),    "Music:");
    text(screenPosX-30, screenPosY+14+14+14, 1, 1, 0, color(0,255,0), "  Blue Reverberance (HEXADECI) "); 
    loadVGM("O 1R>boss.vgm\r");  
    play(50000);
    silence();
    break;  

  default:  
    showSlide=0;        // start from beginning
    break; 
  }  
  showSlide++;
}

// put large label on specified video pages
void title(int times, char * str){
  for (int i = times; i >= 0; i--)
  {
    switchWritePage(i);
    vgm();
    text(3, 22, 2, 2, 1, color(255,255,255),str);
  }
  switchViewPage(0);
  vgm();
}

// clear mini-monitor area with black background
void clearMiniMonitor(){
  switchWritePage(1);
  vgm();
  rect(screenPosX,screenPosY,200,131,0);
  vgm();
  switchWritePage(0);
  vgm();
  rect(screenPosX,screenPosY,200,131,0);
  vgm();
  switchViewPage(0);
  vgm();
}



