( usb device )

( flash/ram transfer: n in bytes )
: >i ( a ia n -- )
  $ 2 l ] u/mod ] swap ] >r
  ] for ] over ] @ ] over ] i! ] swap $ 2 l ] + ] swap $ 1 l ] + ] next
  ] r> ] 0? ] drop ] if ] over ] c@ ] over ] i! ] then
  ] drop ] drop ] ;
: >i, ( a n -- ) ] ihere ] swap ] dup $ 1 l ] + ] 2/ ] iallot ] >i ] ;
: i> ( ia a n -- )
  $ 2 l ] u/mod ] swap ] >r
  ] for ] over ] i@ ] over ] ! ] swap $ 1 l ] + ] swap $ 2 l ] + ] next
  ] r> ] 0? ] drop ] if ] over ] i@ ] over ] c! ] then
  ] drop ] drop ] ;

: setup-invalid ] cr ." setup-invalid" $ 00 l ] ep-set ] ep-stall ] ;

( wait for events )
: ep-pause ( -- ) ] ep-get ] pause ] ep-set ] ;
: wait-rx-out ( -- )
  ] rx-out? ] 0? ] drop ] if ] ;;
  ] then ] ep-pause ] wait-rx-out ] ;
: wait-tx-in  ( -- )
  ] tx-in?  ] 0? ] drop ] if ] ;;
  ] then ] ep-pause ] wait-tx-in ] ;
: wait-ep-ready ( -- )
  ] ep-ready? ] 0? ] drop ] if ] ;;
  ] then ] ep-pause ] wait-ep-ready ] ;

( device address )
$ 1 var address.pending
: address-init ( -- ) ] address.pending ] off ] ;
: address-set ( x -- ) ] usb-address ] address.pending ] on ] ;
: address-status ( -- ) [ address.pending l ] c@ ] 0? ] drop ] if
  ] usb-address-enable ] address.pending ] off ] then ] ;

( data transfer )
( ram to endpoint )
: >ep ( a n -- ) ] for ] c@+ ] epc! ] next ] ;

( endpoint to ram )
: ep>. ( a n -- a' ) ] 0? ] if ] for ] epc@ ] swap ] c!+ ] next ] ; ] then ] drop ] ;
: ep> ( a n -- ) ] ep>. ] drop ] ;

( control endpoint )
$ 40 con control.size
: control-tx-frame ( a n -- a' )
  ] usb-reset? ] 0? ] drop ] if ] drop ] ; ] then
  ] wait-tx-in
  ] 0? ] =if ] drop ] in-ack ] ; ] then
  ] for ] dup ] c@ ] epc! ] 1+ ] next ] in-ack ] ;
: control-tx-frames ( a n -- a' ) ] 0? ] =if ] drop ] ; ] then
  ] for [ control.size l ] control-tx-frame ] next ] ;
: control-tx-zlp ( -- ) $ 0 l ] ep-set $ 0 l $ 0 l ] control-tx-frame ] drop ] ;
: control-tx ( ia n -- ) $ 0 l ] ep-set [ control.size l ] u/mod ] swap ] >r
  ] control-tx-frames ] r> ] control-tx-frame ] drop ] ;

: control-rx ( -- )
  $ 0 l ] ep-set
  ] usb-reset? ] 0? ] drop ] if ] ;; ] then
  ] wait-rx-out ] out-ack ] ;

( data endpoint )
: data-rx ( a n -- )
  ] wait-rx-out ] dup ] ep-bytes ] umin
  ] swap ] over ] - ] >r
  ] ep>.
  ] out-ack ] r> ] 0? ] =if ] 2drop ] ;
  ] then ] data-rx ] ;

: data-tx ( a n -- )
  ] wait-tx-in ] for
    ] wait-ep-ready ] c@+ ] epc!
    ] ep-ready? ] 0? ] drop ] =if ] in-ack ] then
  ] next ] ep-bytes ] 0? ] drop ] if ] in-ack ] then ] drop ] ;

: data-tx-zlp ( -- )
  ] wait-tx-in ] in-ack ] ;

( setup request )
$ 8 var setup.request
: bmRequestType ( -- c ) [ setup.request $ 0 [ + l ] c@ ] ;
: bRequest      ( -- c ) [ setup.request $ 1 [ + l ] c@ ] ;
: wValue        ( -- x ) [ setup.request $ 2 [ + l ]  @ ] ;
: wIndex        ( -- x ) [ setup.request $ 4 [ + l ]  @ ] ;
: wLength       ( -- x ) [ setup.request $ 6 [ + l ]  @ ] ;

( setup response )
$ 20 var setup.response

: descriptor-begin ( -- a ) ] setup.response ] ;
: descriptor-end ( a -- )
  [ setup.response l ] -
  [ setup.response l ] swap
  ] ihere ] >r ] >i, ] r> ] ;;
: d, ( a x -- a' ) ] swap ] !+ ] ;
: dc, ( a c -- a' ) ] swap ] c!+ ] ;

( device descriptor )
[ descriptor-begin
$ 12   [ dc, ( bLength )
$ 01   [ dc, ( bDescriptorType )
$ 0200 [  d, ( bcdUSB )
$ 00   [ dc, ( bDeviceClass )
$ 00   [ dc, ( bDeviceSubClass )
$ 00   [ dc, ( bDeviceProtocol )
$ 40   [ dc, ( bMaxPacketSize0 )
$ ffff [  d, ( idVendor )
$ ffff [  d, ( idProduct )
$ 0000 [  d, ( bcdDevice )
$ 00   [ dc, ( iManufacturer )
$ 00   [ dc, ( iProduct )
$ 01   [ dc, ( iSerialNumber )
$ 01   [ dc, ( bNumConfigurations )
[ descriptor-end con device-descriptor

( language codes string descriptor )
[ descriptor-begin
$ 04   [ dc, ( bLength )
$ 03   [ dc, ( bDescriptorType )
$ 0409 [  d, ( LANGID 0 )
[ descriptor-end con string-descriptor-0

( serial number string descriptor )
[ descriptor-begin
$ 1a   [ dc, ( bLength )
$ 03   [ dc, ( bDescriptorType )
$ 0030 [  d,
$ 0030 [  d,
$ 0030 [  d,
$ 0030 [  d,
$ 0030 [  d,
$ 0030 [  d,
$ 0030 [  d,
$ 0030 [  d,
$ 0030 [  d,
$ 0030 [  d,
$ 0030 [  d,
$ 0030 [  d,
[ descriptor-end con string-descriptor-1

( configuration descriptor )
[ descriptor-begin
$ 09   [ dc, ( bLength )
$ 02   [ dc, ( bDescriptorType )
$ 0020 [  d, ( wTotalLength )
$ 01   [ dc, ( bNumInterfaces )
$ 01   [ dc, ( bConfigurationValue )
$ 00   [ dc, ( iConfiguration )
$ 80   [ dc, ( bmAttributes )
$ 40   [ dc, ( MaxPower )

( interface descriptor )
$ 09   [ dc, ( bLength )
$ 04   [ dc, ( bDescriptorType )
$ 00   [ dc, ( bInterfaceNumber)
$ 00   [ dc, ( bAlternateSetting )
$ 02   [ dc, ( bNumEndpoints )
$ 08   [ dc, ( bInterfaceClass )
$ 06   [ dc, ( bInterfaceSubClass )
$ 50   [ dc, ( bInterfaceProtocol )
$ 00   [ dc, ( iInterface )

( in endpoint descriptor )
$ 07   [ dc, ( bLength )
$ 05   [ dc, ( bDescriptorType )
$ 81   [ dc, ( bEndpointAddress )
$ 02   [ dc, ( bmAttributes )
$ 0040 [  d, ( wMaxPacketSize )
$ 00   [ dc, ( bInterval )

( out endpoint descriptor )
$ 07   [ dc, ( bLength )
$ 05   [ dc, ( bDescriptorType )
$ 02   [ dc, ( bEndpointAddress )
$ 02   [ dc, ( bmAttributes )
$ 0040 [  d, ( wMaxPacketSize )
$ 00   [ dc, ( bInterval )

[ descriptor-end con configuration-descriptor

$ 00 con control-endpoint
$ 01 con in-endpoint
$ 02 con out-endpoint

$ 03 con #endpoints

: ep-valid? ( ep -- f )
  [ #endpoints l ] ? ] u<if
    ] set-ep ] ep-enabled? ] ;
  ] then $ 0000 l ] ;

: setup-control-endpoint ( -- )
  ] control-endpoint ] ep-set
  ] ep-enable
  [ type-control l ] ep-type
  [ size-64bytes l ] ep-size
  [ bank-single l ] ep-bank
  ] ep-allocate ] ;

: setup-ms-in-endpoint ( -- )
  ] in-endpoint ] ep-set
  ] ep-enable
  [ type-bulk l ] ep-type
  [ dir-in l ] ep-dir
  [ size-64bytes l ] ep-size
  [ bank-single l ] ep-bank
  ] ep-allocate ] ;

: setup-ms-out-endpoint ( -- )
  ] out-endpoint ] ep-set
  ] ep-enable
  [ type-bulk l ] ep-type
  [ dir-out l ] ep-dir
  [ size-64bytes l ] ep-size
  [ bank-single l ] ep-bank
  ] ep-allocate ] ;

: ep. $ eb l ] c@ ] ep-ready? ] rx-out? ] tx-in? ] ep-bytes ] ep-get
  ] cr ." ep: " ] b. ] h. ] b. ] b. ] b. ] b. ] ;
: eps.
  $ 00 l ] ep-set ] ep.
  $ 01 l ] ep-set ] ep.
  $ 02 l ] ep-set ] ep.
  $ 03 l ] ep-set ] ep.
  $ 04 l ] ep-set ] ep.
  $ 05 l ] ep-set ] ep.
  $ 06 l ] ep-set ] ep. ] ;

: setup-ms-endpoints ( -- )
  ] setup-ms-in-endpoint
  ] setup-ms-out-endpoint ] ;

( mass storage )

$ 1 con #luns
$ 0 con ms.interface

$ 1 var ms.enabled

: configuration01 ( -- )
  ] setup-ms-endpoints
  [ ms.enabled l ] on ] ;

: split ( x -- cl ch ) ] dup $ 00ff l ] and ] swap $ ff00 l ] and ] >< ] ;
: join ( cl ch -- x ) ] >< $ ff00 l ] and ] swap $ 00ff l ] and ] or ] ;

: le32@ ( a -- d ) ] @+ ] swap ] @ ] ;
: le32! ( d a -- ) ] >r ] swap ] r> ] !+ ] ! ] ;

: be32@ ( a -- d ) ] @+ ] >< ] swap ] @ ] >< ] swap ] ;
: be32! ( d a -- ) ] rot ] >< ] rot ] >< ] rot ] !+ ] ! ] ;

: be16@ ( a -- x ) ] @ ] >< ] ;

$ 2 var residue

: ms-tx ( a n -- ) ] dup [ residue l ] -! ] in-endpoint ] ep-set ] data-tx ] ;
: ms-tx-zlp ( -- ) ] in-endpoint ] ep-set ] data-tx-zlp ] ;
: ms-rx ( a n -- ) ] dup [ residue l ] -! ] out-endpoint ] ep-set ] data-rx ] ;

$ 1f var cbw
: dCBWSignature          ( -- d ) [ cbw $ 0 [ + l ] le32@ ] ;
: dCBWTag                ( -- d ) [ cbw $ 4 [ + l ] le32@ ] ;
: dCBWDataTransferLength ( -- d ) [ cbw $ 8 [ + l ] le32@ ] ;
: bmCBWFlags             ( -- c ) [ cbw $ c [ + l ] c@ ] ;
: bCBWLUN                ( -- c ) [ cbw $ d [ + l ] c@ $ 0f l ] and ] ;
: bCBWCBLength           ( -- c ) [ cbw $ e [ + l ] c@ $ 1f l ] and ] ;
: CBWCB                  ( -- a ) [ cbw $ f [ + l ] ;

: cbw-rx ( -- )
  [ cbw l $ 1f l ] ms-rx
  ] dCBWDataTransferLength ] drop [ residue l ] ! ] ;

$ 0d var csw
: dCSWSignature   ( d -- ) [ csw $ 0 [ + l ] le32! ] ;
: dCSWTag         ( d -- ) [ csw $ 4 [ + l ] le32! ] ;
: dCSWDataResidue ( d -- ) [ csw $ 8 [ + l ] le32! ] ;
: bCSWStatus      ( c -- ) [ csw $ c [ + l ] c! ] ;

: csw-tx ( -- )
  $ 5342 $ 5355 ll ] dCSWSignature
  ] dCBWTag ] dCSWTag
  [ residue l ] @ $ 0000 l ] dCSWDataResidue
  [ csw l $ d l ] ms-tx ] ;
: csw-passed ( -- ) $ 00 l ] bCSWStatus ] csw-tx ] ;
: csw-failed ( -- ) $ 01 l ] bCSWStatus ] csw-tx ] ;
: csw-phase  ( -- ) $ 02 l ] bCSWStatus ] csw-tx ] ;

( scsi error )
$ 1 var sense

: scsi-passed ( -- ) $ 00 l [ sense l ] c! ] csw-passed ] ;
: scsi-illegal-request ( -- ) $ 05 l [ sense l ] c! ] ms-tx-zlp ] csw-failed ] ;

( scsi commands )
$ 200 con scsi.sector-size
[ scsi.sector-size var scsi.data

: at-per-scsi ( -- u )
  [ scsi.sector-size l
  [ at-sector-size l ] @ ] u/ ] ;

: scsi-invalid ( -- )
  ] cr ." scsi-invalid"
  ] ms-tx-zlp ] csw-failed ] ;

: scsi.operation ( -- c ) [ CBWCB $ 0 [ + l ] c@ ] ;
: scsi.lun       ( -- c ) [ CBWCB $ 1 [ + l ] c@ $ 5 l ] rshift ] ;

: scsi-sector@ ( lba a -- ) ] swap ] at-per-scsi ] u* ] swap ] at-per-scsi ] for
    ] 2dup ] at-sector@ ] swap ] 1+ ] swap [ at-sector-size l ] @ ] +
  ] next ] 2drop ] ;

: scsi-sector! ( a lba -- ) ] at-per-scsi ] u* ] at-per-scsi ] for
    ] 2dup ] at-sector! ] swap [ at-sector-size l ] @ ] + ] swap ] 1+
  ] next ] 2drop ] ;

( test unit ready )
: test-unit-ready.control@ ( -- c ) [ CBWCB $ 1 [ + l ] c@ ] ;

: scsi-test-unit-ready ( -- )
  ] scsi-passed ] ;

( request sense )
: request-sense.length@  ( -- c ) [ CBWCB $ 4 [ + l ] c@ ] ;
: request-sense.control@ ( -- c ) [ CBWCB $ 5 [ + l ] c@ ] ;

: request-sense.sense-key! ( c -- ) $ 0f l ] and [ scsi.data $ 2 [ + l ] c@
  $ f0 l ] and ] or [ scsi.data $ 2 [ + l ] c! ] ;

[ here
$ f0 [ dc,
$ 00 [ dc,
$ 00 [ dc,
$ 00 [ dc,
$ 00 [ dc,
$ 00 [ dc,
$ 00 [ dc,
$ 0a [ dc,
$ 00 [ dc,
$ 00 [ dc,
$ 00 [ dc,
$ 00 [ dc,
$ 00 [ dc,
$ 00 [ dc,
$ 00 [ dc,
$ 80 [ dc,
$ 00 [ dc,
$ 00 [ dc,
[ drop
[ here [ ihere $ 12 [ >i
[ ihere $ 12 [ 2/ [ iallot con request-sense.data

: scsi-request-sense ( -- )
  ] request-sense.data ] scsi.data $ 12 l ] i>
  [ sense l ] c@ ] request-sense.sense-key!
  ] scsi.data $ 12 l ] ms-tx ] scsi-passed ] ;

( mode sense 6 )
: mode-sense-6.dbd@       ( -- c ) [ CBWCB $ 1 [ + l ] c@ $ 08 l ] and $ 3 l ] rshift ] ;
: mode-sense-6.pc@        ( -- c ) [ CBWCB $ 2 [ + l ] c@ $ c0 l ] and $ 6 l ] rshift ] ;
: mode-sense-6.page-code@ ( -- c ) [ CBWCB $ 2 [ + l ] c@ $ 3f l ] and ] ;
: mode-sense-6.length@    ( -- c ) [ CBWCB $ 4 [ + l ] c@ ] ;
: mode-sense-6.control@   ( -- c ) [ CBWCB $ 5 [ + l ] c@ ] ;

[ here
$ 03 [ dc,
$ 00 [ dc,
$ 00 [ dc,
$ 00 [ dc,
[ drop
[ here [ ihere $ 4 [ >i
[ ihere $ 4 [ 2/ [ iallot con mode-sense-6.data

: scsi-mode-sense-6 ( -- )
  ] cr ." mode-sense-6"
  ] mode-sense-6.data ] scsi.data $ 4 l ] i>
  ] scsi.data $ 4 l ] ms-tx ] scsi-passed ] ;

( inquiry )
: inquiry.evpd@      ( -- c ) [ CBWCB $ 1 [ + l ] c@ $ 01 l ] and ] ;
: inquiry.page-code@ ( -- c ) [ CBWCB $ 2 [ + l ] c@ ] ;
: inquiry.length@    ( -- u ) [ CBWCB $ 3 [ + l ] be16@ ] ;
: inquiry.control@   ( -- c ) [ CBWCB $ 5 [ + l ] c@ ] ;

[ here
$ 00 [ dc,
$ 00 [ dc,
$ 02 [ dc,
$ 00 [ dc,
$ 20 [ dc,
$ 00 [ dc,
$ 00 [ dc,
$ 10 [ dc,
$ 4b [ dc,
$ 52 [ dc,
$ 55 [ dc,
$ 45 [ dc,
$ 20 [ dc,
$ 20 [ dc,
$ 20 [ dc,
$ 20 [ dc,
$ 43 [ dc,
$ 41 [ dc,
$ 42 [ dc,
$ 42 [ dc,
$ 41 [ dc,
$ 47 [ dc,
$ 45 [ dc,
$ 20 [ dc,
$ 46 [ dc,
$ 4c [ dc,
$ 41 [ dc,
$ 53 [ dc,
$ 48 [ dc,
$ 20 [ dc,
$ 20 [ dc,
$ 20 [ dc,
$ 00 [ dc,
$ 00 [ dc,
$ 00 [ dc,
$ 00 [ dc,
[ drop
[ here [ ihere $ 24 [ >i
[ ihere $ 24 [ 2/ [ iallot con inquiry.data

: scsi-inquiry ( -- )
  ] cr ." inquiry"
  ] inquiry.evpd@ ] 0? ] drop ] if ] scsi-invalid ] ; ] then
  ] inquiry.page-code@ ] 0? ] drop ] if ] scsi-invalid ] ; ] then
  ] inquiry.data ] scsi.data $ 24 l ] i>
  ] scsi.data $ 24 l ] ms-tx ] scsi-passed ] ;

( read capacity )
: read-capacity.reladr@  ( -- c ) [ CBWCB $ 1 [ + l ] c@ $ 01 l ] and ] ;
: read-capacity.lba@     ( -- d ) [ CBWCB $ 2 [ + l ] be32@ ] ;
: read-capacity.pmi@     ( -- c ) [ CBWCB $ 8 [ + l ] c@ $ 01 l ] and ] ;
: read-capacity.control@ ( -- x ) [ CBWCB $ 9 [ + l ] c@ ] ;

: read-capacity.lba!    ( d -- ) [ scsi.data $ 0 [ + l ] be32! ] ;
: read-capacity.length! ( d -- ) [ scsi.data $ 4 [ + l ] be32! ] ;

: scsi-read-capacity ( -- )
  ] cr ." read-capacity"
  ] read-capacity.reladr@ ] 0? ] drop ] if ] scsi-invalid ] ; ] then
  ( ignore pmi since flash has no seek delay )
  $ 0000 $ 8000 [ scsi.sector-size [ u/ [ 1- l l ] read-capacity.lba!
  $ 0000 [ scsi.sector-size l l ] read-capacity.length!
  ] scsi.data $ 8 l ] ms-tx ] scsi-passed ] ;

( read 10 )
: read-10.dpo@     ( -- c ) [ CBWCB $ 1 [ + l ] c@ $ 10 l ] and $ 4 l ] rshift ] ;
: read-10.fua@     ( -- c ) [ CBWCB $ 1 [ + l ] c@ $ 08 l ] and $ 3 l ] rshift ] ;
: read-10.reladr@  ( -- c ) [ CBWCB $ 1 [ + l ] c@ $ 01 l ] and ] ;
: read-10.lba@     ( -- d ) [ CBWCB $ 2 [ + l ] be32@ ] ;
: read-10.length@  ( -- u ) [ CBWCB $ 7 [ + l ] be16@ ] ;
: read-10.control@ ( -- c ) [ CBWCB $ 9 [ + l ] c@ ] ;

( todo: check for real )
: valid-address? ( d u -- f ) $ 0000 l ] d+
  ] 0? ] drop ] if ] drop $ 0000 l ] ; ] then
  [ at-num-sectors l ] ? ] drop ] <if $ ffff l ] ; ] then
  $ 0000 l ] ;

: scsi-read ( lba length -- )
  ] over [ scsi.data l ] scsi-sector@
  [ scsi.data l [ scsi.sector-size l ] ms-tx
  ] swap $ 1 l ] +
  ] swap $ 1 l ] - ] if ] scsi-read ] ; ] then
  ] 2drop ] ;

: scsi-read-10 ( -- )
  ] cr ." read-10 "
  ] read-10.reladr@ ] 0? ] drop ] if ] scsi-illegal-request ] ; ] then
  ( ignore dpo since we have no cache )
  ( ignore fua since we have no cache )
  ] read-10.lba@ ] read-10.length@ ] valid-address? ] 0? ] drop ] =if
    ] scsi-illegal-request ] ; ] then
  ( todo: use entire lba field )
  ( when bank switching is implemented )
  ] read-10.lba@ ] h. ] h. ] read-10.length@ ] h.
  ] read-10.lba@ ] drop ] read-10.length@ ] scsi-read
  ] scsi-passed ] ;

( write 10 )
: write-10.dpo@     ( -- c ) [ CBWCB $ 1 [ + l ] c@ $ 10 l ] and $ 4 l ] rshift ] ;
: write-10.fua@     ( -- c ) [ CBWCB $ 1 [ + l ] c@ $ 08 l ] and $ 3 l ] rshift ] ;
: write-10.ebp@     ( -- c ) [ CBWCB $ 1 [ + l ] c@ $ 04 l ] and $ 2 l ] rshift ] ;
: write-10.reladr@  ( -- c ) [ CBWCB $ 1 [ + l ] c@ $ 01 l ] and ] ;
: write-10.lba@     ( -- d ) [ CBWCB $ 2 [ + l ] be32@ ] ;
: write-10.length@  ( -- u ) [ CBWCB $ 7 [ + l ] be16@ ] ;
: write-10.control@ ( -- c ) [ CBWCB $ 9 [ + l ] c@ ] ;

: scsi-write ( lba length -- )
  [ scsi.data l [ scsi.sector-size l ] ms-rx
  ] over [ scsi.data l ] swap ] scsi-sector!
  ] swap $ 1 l ] +
  ] swap $ 1 l ] - ] if ] scsi-write ] ; ] then
  ] 2drop ] ;

: scsi-write-10 ( -- )
  ] cr ." write-10 "
  ] write-10.reladr@ ] 0? ] drop ] if ] scsi-illegal-request ] ; ] then
  ( ignore dpo since ) ( we have no read cache )
  ( ignore fua since ) ( we have no write cache )
  ( ignore ebp since ) ( flash erases automatically )
  ] write-10.lba@ ] write-10.length@ ] valid-address? ] 0? ] drop ] =if
    ] scsi-illegal-request ] ; ] then
  ] write-10.lba@ ] h. ] h. ] write-10.length@ ] h.
  ] write-10.lba@ ] drop ] write-10.length@ ] scsi-write
  ] scsi-passed ] ;

( mass storage setup requests )

: setup-ms-get-max-lun ( -- )
  ] cr ." ms-get-max-lun"
  ] bmRequestType $ a1 l ] ? ] drop ] if ] setup-invalid ] ; ] then
  ] wValue ] 0? ] drop ] if ] setup-invalid ] ; ] then
  ] wIndex [ ms.interface l ] ? ] drop ] if ] setup-invalid ] ; ] then
  ] wLength $ 01 l ] ? ] drop ] if ] setup-invalid ] ; ] then
  [ #luns [ 1- l [ setup.response l ] c!
  [ setup.response l $ 1 l ] control-tx ] control-rx ] ;

: setup-ms-reset       ( -- )
  ] cr ." ms-reset"
  ] setup-invalid ] ;

: setup-ms ( -- )
  ] bRequest
  $ fe l ] ? ] =if ] drop ] setup-ms-get-max-lun ] ; ] then
  $ ff l ] ? ] =if ] drop ] setup-ms-reset       ] ; ] then
  ] drop ] setup-invalid ] ;

: ms-cbw ( -- )
  ] cr ." scsi"
  ] scsi.operation
  $ 00 l ] ? ] =if ] drop ] scsi-test-unit-ready ] ; ] then
  $ 03 l ] ? ] =if ] drop ] scsi-request-sense   ] ; ] then
  $ 12 l ] ? ] =if ] drop ] scsi-inquiry         ] ; ] then
  $ 1a l ] ? ] =if ] drop ] scsi-mode-sense-6    ] ; ] then
  $ 25 l ] ? ] =if ] drop ] scsi-read-capacity   ] ; ] then
  $ 28 l ] ? ] =if ] drop ] scsi-read-10         ] ; ] then
  $ 2a l ] ? ] =if ] drop ] scsi-write-10        ] ; ] then
  ( ] drop ) ] b. ] scsi-illegal-request ] ;

: ms-task-xt
  [ ms.enabled l ] c@ ] 0? ] drop ] if
    ] cr ." ms"
    ] cbw-rx
    ] cr ." cbw"
    ( todo: check valid cbw )
    ( todo: check meaningful cbw )
    ( [ cbw l $ 1f l ] dump )
    ] ms-cbw
  ] then ] pause ] ms-task-xt ] ;

$ 80 var ms-task
: ms-task-reset [ ' ms-task-xt l $ 40 l $ 40 l [ ms-task l ] task-init ] ;
: ms-task-init ] ms-task-reset [ ms-task l ] task-queue ] ;

( configuration )
$ 1 var configuration
$ 1 con #configurations

: deconfigure-endpoint ( n -- )
  ] ep-set ] ep-disable ] ep-deallocate ] ;
: configuration00 ( -- )
  $ 01 l ] deconfigure-endpoint
  $ 02 l ] deconfigure-endpoint
  $ 03 l ] deconfigure-endpoint
  $ 04 l ] deconfigure-endpoint
  $ 05 l ] deconfigure-endpoint
  $ 06 l ] deconfigure-endpoint ] ;

: configure ( n -- )
  ] cr ." configure: " ] dup ] h.
  [ #configurations l ] umin
  ] dup [ configuration l ] c!
  ] jump
  [ ' configuration00 [ i,
  [ ' configuration01 [ i,

: setup-get-status-device    ] cr ." get-status-device"    ] setup-invalid ] ;
: setup-get-status-interface ] cr ." get-status-interface" ] setup-invalid ] ;
: setup-get-status-endpoint  ] cr ." get-status-endpoint"  ] setup-invalid ] ;
: setup-get-status        ( bmRequestType -- )
  $ 80 l ] ? ] =if ] drop ] setup-get-status-device    ] ; ] then
  $ 81 l ] ? ] =if ] drop ] setup-get-status-interface ] ; ] then
  $ 82 l ] ? ] =if ] drop ] setup-get-status-endpoint  ] ; ] then
  ] drop ] setup-invalid ] ;

: setup-clear-feature-device    ] cr ." clear-feature-device"    ] setup-invalid ] ;
: setup-clear-feature-interface ] cr ." clear-feature-interface" ] setup-invalid ] ;
: setup-clear-feature-endpoint  ] cr ." clear-feature-endpoint"  ] setup-invalid ] ;
: setup-clear-feature     ( bmRequestType -- )
  $ 00 l ] ? ] =if ] drop ] setup-clear-feature-device    ] ; ] then
  $ 01 l ] ? ] =if ] drop ] setup-clear-feature-interface ] ; ] then
  $ 02 l ] ? ] =if ] drop ] setup-clear-feature-endpoint  ] ; ] then
  ] drop ] setup-invalid ] ;

: setup-set-feature-device    ] cr ." set-feature-device"    ] setup-invalid ] ;
: setup-set-feature-interface ] cr ." set-feature-interface" ] setup-invalid ] ;
: setup-set-feature-endpoint  ] cr ." set-feature-endpoint"  ] setup-invalid ] ;
: setup-set-feature       ( bmRequestType -- )
  $ 00 l ] ? ] =if ] drop ] setup-set-feature-device    ] ; ] then
  $ 01 l ] ? ] =if ] drop ] setup-set-feature-interface ] ; ] then
  $ 02 l ] ? ] =if ] drop ] setup-set-feature-endpoint  ] ; ] then
  ] drop ] setup-invalid ] ;

: setup-set-address-device ] cr ." set-address-device"
  ] wIndex ] 0? ] drop ] if ] setup-invalid ] ; ] then
  ] wLength ] 0? ] drop ] if ] setup-invalid ] ; ] then
  ] wValue ] dup ] h. ] usb-address
  ] control-tx-zlp ] wait-tx-in ] usb-address-enable ] ;
: setup-set-address       ( bmRequestType -- )
  $ 00 l ] ? ] =if ] drop ] setup-set-address-device ] ; ] then
  ] drop ] setup-invalid ] ;


: descriptor-tx ( ia n -- ) ] wLength ] umin ] dup ] >r
  [ setup.response l ] swap ] i>
  [ setup.response l ] r> ] control-tx ] control-rx ] ;
: valid-langid?
  $ 0000 l ] ? ] =if ] drop $ ffff l ] ; ] then
  $ 0409 l ] ? ] =if ] drop $ ffff l ] ; ] then
  ] drop $ 0000 l ] ;
: setup-get-descriptor-device-device
  ] cr ." device"
  ] wIndex ] 0? ] drop ] if ] setup-invalid ] ; ] then
  ] wValue ] low
  $ 00 l ] ? ] =if ] drop [ device-descriptor l $ 12 l ] descriptor-tx ] ; ] then
  ] drop ] setup-invalid ] ;
: setup-get-descriptor-device-configuration
  ] cr ." configuration"
  ] wIndex ] 0? ] drop ] if ] setup-invalid ] ; ] then
  ] wValue ] low
  $ 00 l ] ? ] =if ] drop [ configuration-descriptor l $ 20 l ] descriptor-tx ] ; ] then
  ] drop ] setup-invalid ] ;
: setup-get-descriptor-device-string
  ] cr ." string"
  ] wIndex ] valid-langid? ] 0? ] drop ] =if ] setup-invalid ] ; ] then
  ] wValue ] low
  $ 00 l ] ? ] =if ] drop [ string-descriptor-0 l $ 04 l ] descriptor-tx ] ; ] then
  $ 01 l ] ? ] =if ] drop [ string-descriptor-1 l $ 1a l ] descriptor-tx ] ; ] then
  ] drop ] setup-invalid ] ;
: setup-get-descriptor-device-interface
  ] cr ." interface"         ] setup-invalid ] ;
: setup-get-descriptor-device-endpoint
  ] cr ." endpoint"          ] setup-invalid ] ;
: setup-get-descriptor-device-device-qualifier
  ] cr ." device-qualifier"  ] setup-invalid ] ;
: setup-get-descriptor-device-other-speed-configuration
  ] cr ." other-speed"       ] setup-invalid ] ;
: setup-get-descriptor-device-interface-power
  ] cr ." interface-power"   ] setup-invalid ] ;
: setup-get-descriptor-device ] cr ." get-descriptor-device"
  ] wValue ] high
  $ 01 l ] ? ] =if ] drop ] setup-get-descriptor-device-device                    ] ; ] then
  $ 02 l ] ? ] =if ] drop ] setup-get-descriptor-device-configuration             ] ; ] then
  $ 03 l ] ? ] =if ] drop ] setup-get-descriptor-device-string                    ] ; ] then
  $ 04 l ] ? ] =if ] drop ] setup-get-descriptor-device-interface                 ] ; ] then
  $ 05 l ] ? ] =if ] drop ] setup-get-descriptor-device-endpoint                  ] ; ] then
  $ 06 l ] ? ] =if ] drop ] setup-get-descriptor-device-device-qualifier          ] ; ] then
  $ 07 l ] ? ] =if ] drop ] setup-get-descriptor-device-other-speed-configuration ] ; ] then
  $ 08 l ] ? ] =if ] drop ] setup-get-descriptor-device-interface-power           ] ; ] then
  ] drop ] setup-invalid ] ;
: setup-get-descriptor    ( bmRequestType -- )
  $ 80 l ] ? ] =if ] drop ] setup-get-descriptor-device ] ; ] then
  ] drop ] setup-invalid ] ;

: setup-set-descriptor-device ] cr ." set-descriptor-device" ] setup-invalid ] ;
: setup-set-descriptor    ( bmRequestType -- )
  $ 00 l ] ? ] =if ] drop ] setup-set-descriptor-device ] ; ] then
  ] drop ] setup-invalid ] ;

: setup-get-configuration-device ] cr ." get-configuration-device" ] setup-invalid ] ;
: setup-get-configuration ( bmRequestType -- )
  $ 80 l ] ? ] =if ] drop ] setup-get-configuration-device ] ; ] then
  ] drop ] setup-invalid ] ;

: setup-set-configuration-device ] cr ." set-configuration-device"
  ] wValue ] high ] 0? ] drop ] if ] setup-invalid ] ; ] then
  ] wIndex ] 0? ] drop ] if ] setup-invalid ] ; ] then
  ] wLength ] 0? ] drop ] if ] setup-invalid ] ; ] then
  ] wValue ] low [ #configurations [ 1+ l ] ? ] <if
    ] configure
    [ control-endpoint l ] ep-set ] control-tx-zlp ] ;
  ] then ] drop ] setup-invalid ] ;
: setup-set-configuration ( bmRequestType -- )
  $ 00 l ] ? ] =if ] drop ] setup-set-configuration-device ] ; ] then
  ] drop ] setup-invalid ] ;

: setup-get-interface-interface ] cr ." get-interface-interface" ] setup-invalid ] ;
: setup-get-interface     ( bmRequestType -- )
  $ 81 l ] ? ] =if ] drop ] setup-get-interface-interface ] ; ] then
  ] drop ] setup-invalid ] ;

: setup-set-interface-interface ] cr ." set-interface-interface" ] setup-invalid ] ;
: setup-set-interface     ( bmRequestType -- )
  $ 01 l ] ? ] =if ] drop ] setup-set-interface-interface ] ; ] then
  ] drop ] setup-invalid ] ;

: setup-synch-frame-endpoint ] cr ." synch-frame-endpoint" ] setup-invalid ] ;
: setup-synch-frame       ( bmRequestType -- )
  $ 82 l ] ? ] =if ] drop ] setup-synch-frame-endpoint ] ; ] then
  ] drop ] setup-invalid ] ;

: setup-reserved          ( bmRequestType -- )
  ] drop ] setup-invalid ] ;

: setup-standard ( -- )
  ] bmRequestType ] bRequest $ 0d l ] umin ] jump
  [ ' setup-get-status        [ i,
  [ ' setup-clear-feature     [ i,
  [ ' setup-reserved          [ i,
  [ ' setup-set-feature       [ i,
  [ ' setup-reserved          [ i,
  [ ' setup-set-address       [ i,
  [ ' setup-get-descriptor    [ i,
  [ ' setup-set-descriptor    [ i,
  [ ' setup-get-configuration [ i,
  [ ' setup-set-configuration [ i,
  [ ' setup-get-interface     [ i,
  [ ' setup-set-interface     [ i,
  [ ' setup-synch-frame       [ i,
  [ ' setup-reserved          [ i,
  
: setup-class    ( -- ) ] setup-ms ] ;
: setup-vendor   ( -- ) ] setup-invalid ] ;
: setup-reserved ( -- ) ] setup-invalid ] ;

: setup [ setup.request l $ 8 l ] ep> ] setup-ack
  ] cr ." setup " ( [ setup.request l $ 8 l ] dump )
  ] bmRequestType $ 60 l ] and $ 5 l ] rshift ] jump
  [ ' setup-standard [ i,
  [ ' setup-class    [ i,
  [ ' setup-vendor   [ i,
  [ ' setup-reserved [ i,

: usb-control ( -- )
  ] control-endpoint ] ep-set
  ] rx-setup? ] 0? ] drop ] if ] setup ] then ] ;;

: usb-reset ] cr ." reset" ] usb-reset-ack
  ] ms-task-reset
  ] setup-control-endpoint ] ;

: usb-step
  ] usb-reset? ] 0? ] drop ] if ] usb-reset ] then ] ;;

: usb-task-xt
  ] usb-step
  ] usb-control
  ] pause ] usb-task-xt ] ;

$ 80 var usb-task
: usb-run [ ' usb-task-xt l $ 40 l $ 40 l [ usb-task l ] task-init
  [ usb-task l ] task-queue ] ;

: usb-init
  $ 00 l [ configuration l ] c!
  ] pll
  ] usb-device
  ] usb
  ] usb-thaw
  ] usb-run
  ] usb-attach
] ;

: doit ( -- )
  ] at-init
  [ ms.enabled l ] off
  ] usb-init
  ] ms-task-init ] ;

