( colecovision flash cartridge programmer )

include netlist.fs

( parts )

s" j1" part cart
s" j2" part usb

s" h1" part jtag
s" h2" part rs232
s" h3" part io

s" u1" part avr ( tqfp64 )
s" u2" part adm ( msop10 )

s" x1" part xtal ( 16M cs10 )

s" c1" part xtalc1  ( 22p 0603 )
s" c2" part xtalc2  ( 22p 0603 )
s" c3" part dec-usb ( 10u 1206 )
s" c4" part usbc    ( 1u 0805 )
s" c5" part dec-avr1 ( 100n 0603 )
s" c6" part dec-avr2 ( 100n 0603 )
s" c7" part dec-avr3 ( 100n 0603 )
s" c8" part dec-adm ( 100n 0603 )
s" c9"  part pump1 ( 100n 0603 )
s" c10" part pump2 ( 100n 0603 )

s" r1" part usbd+r      ( 22r 0603 )
s" r2" part usbd-r      ( 22r 0603 )
s" r3" part resetpullup ( 10k 0603 )

( nets )

net gnd
net vcc

net a0
net a1
net a2
net a3
net a4
net a5
net a6
net a7
net a8
net a9
net a10
net a11
net a12
net a13
net a14

net d0
net d1
net d2
net d3
net d4
net d5
net d6
net d7

net en0
net en1
net en2
net en3

net tck
net tdo
net tms
net tdi

net xtal1
net xtal2

net d-bus
net d+bus
net d-micro
net d+micro
net ucap

net reset

net c1-
net c1+
net v-

net txdmicro
net rxdmicro
net txdbus
net rxdbus

net io0
net io1
net io2
net io3
net io4
net io5
net io6
net io7

net dtrdsr
net rtscts

net nc

( connections )

cart cart-a0  a0
cart cart-a1  a1
cart cart-a2  a2
cart cart-a3  a3
cart cart-a4  a4
cart cart-a5  a5
cart cart-a6  a6
cart cart-a7  a7
cart cart-a8  a8
cart cart-a9  a9
cart cart-a10 a10
cart cart-a11 a11
cart cart-a12 a12
cart cart-a13 a13
cart cart-a14 a14

cart cart-d0 d0
cart cart-d1 d1
cart cart-d2 d2
cart cart-d3 d3
cart cart-d4 d4
cart cart-d5 d5
cart cart-d6 d6
cart cart-d7 d7

cart cart-en0 en0
cart cart-en1 en1
cart cart-en2 en2
cart cart-en3 en3

cart cart-shield nc
cart cart-gnd    gnd
cart cart-vcc    vcc

avr at90usbx7-pa0 d0
avr at90usbx7-pa1 d1
avr at90usbx7-pa2 d2
avr at90usbx7-pa3 d3
avr at90usbx7-pa4 d4
avr at90usbx7-pa5 d5
avr at90usbx7-pa6 d6
avr at90usbx7-pa7 d7

avr at90usbx7-pb0 a8
avr at90usbx7-pb1 a9
avr at90usbx7-pb2 a10
avr at90usbx7-pb3 a11
avr at90usbx7-pb4 a12
avr at90usbx7-pb5 a13
avr at90usbx7-pb6 a14
avr at90usbx7-pb7 nc

avr at90usbx7-pc0 a0
avr at90usbx7-pc1 a1
avr at90usbx7-pc2 a2
avr at90usbx7-pc3 a3
avr at90usbx7-pc4 a4
avr at90usbx7-pc5 a5
avr at90usbx7-pc6 a6
avr at90usbx7-pc7 a7

avr at90usbx7-pd0 nc
avr at90usbx7-pd1 nc
avr at90usbx7-rxd1 rxdmicro
avr at90usbx7-txd1 txdmicro
avr at90usbx7-pd4 en0
avr at90usbx7-pd5 en1
avr at90usbx7-pd6 en2
avr at90usbx7-pd7 en3

avr at90usbx7-pe0 nc
avr at90usbx7-pe1 nc
avr at90usbx7-pe2 nc
avr at90usbx7-pe3 nc
avr at90usbx7-pe4 io4
avr at90usbx7-pe5 io5
avr at90usbx7-pe6 io6
avr at90usbx7-pe7 io7

avr at90usbx7-pf0 io0
avr at90usbx7-pf1 io1
avr at90usbx7-pf2 io2
avr at90usbx7-pf3 io3
avr at90usbx7-tck tck
avr at90usbx7-tms tms
avr at90usbx7-tdo tdo
avr at90usbx7-tdi tdi

avr at90usbx7-gnd0 gnd
avr at90usbx7-vcc0 vcc
dec-avr1 1 gnd
dec-avr1 2 vcc

avr at90usbx7-gnd1 gnd
avr at90usbx7-vcc1 vcc
dec-avr2 1 gnd
dec-avr2 2 vcc

avr at90usbx7-aref nc
avr at90usbx7-agnd gnd
avr at90usbx7-avcc vcc
dec-avr3 1 gnd
dec-avr3 2 vcc

avr at90usbx7-uvcc vcc
avr at90usbx7-d-   d-micro
avr at90usbx7-d+   d+micro
avr at90usbx7-ugnd gnd
avr at90usbx7-ucap ucap
avr at90usbx7-vbus vcc

avr at90usbx7-/reset reset
avr at90usbx7-xtal1 xtal1
avr at90usbx7-xtal2 xtal2

jtag avrjtag-tck tck
jtag avrjtag-tms tms
jtag avrjtag-tdo tdo
jtag avrjtag-tdi tdi

jtag avrjtag-/reset reset

jtag avrjtag-gnd0 gnd
jtag avrjtag-gnd1 gnd
jtag avrjtag-vcc  vcc
jtag avrjtag-vref vcc

jtag avrjtag-nc nc

xtal 1 xtal1
xtal 2 xtal2
xtalc1 1 xtal1
xtalc1 2 gnd
xtalc2 1 xtal2
xtalc2 2 gnd

usb usbb-vbus   vcc
usb usbb-d-     d-bus
usb usbb-d+     d+bus
usb usbb-gnd    gnd
usb usbb-shield gnd
dec-usb 1 gnd
dec-usb 2 vcc

usbd-r 1 d-bus
usbd-r 2 d-micro

usbd+r 1 d+bus
usbd+r 2 d+micro

usbc 1 ucap
usbc 2 gnd

resetpullup 1 reset
resetpullup 2 vcc

adm adm101e-c1- c1-
adm adm101e-c1+ c1+
pump1 1 c1-
pump1 2 c1+

adm adm101e-v- v-
pump2 1 v-
pump2 2 gnd

adm adm101e-tin  txdmicro
adm adm101e-rout rxdmicro

adm adm101e-tout txdbus
adm adm101e-rin  rxdbus

adm adm101e-sd gnd

adm adm101e-gnd gnd
adm adm101e-vcc vcc
dec-adm 1 gnd
dec-adm 2 vcc

io 01 io0
io 02 io1
io 03 io2
io 04 io3
io 05 io4
io 06 io5
io 07 io6
io 08 io7
io 09 gnd
io 10 vcc

rs232 rs232idc-cd  nc

rs232 rs232idc-dsr dtrdsr
rs232 rs232idc-dtr dtrdsr

rs232 rs232idc-rts rtscts
rs232 rs232idc-cts rtscts

rs232 rs232idc-rxd txdbus
rs232 rs232idc-txd rxdbus

rs232 rs232idc-ri  nc

rs232 rs232idc-gnd gnd

.s nets.
bye

