( at29cx flash )

: address-out ( -- ) $ ff l [ ddrb l ] c! $ ff l [ ddrc l ] c! ] ;
: address-put ( a -- ) ] dup ] high [ portb l ] c! ] low [ portc l ] c! ] ;
: data-in ( -- ) $ 00 l [ ddra l ] c! ] ;
: data-out ( -- ) $ ff l [ ddra l ] c! ] ;
: data-put ( c -- ) [ porta l ] c! ] ;
: data-get ( -- c ) [ pina l ] c@ ] ;
: en-out ( -- ) [ ddrd l ] c@ $ f0 l ] or [ ddrd l ] c! ] ;
: en-put ( x -- ) [ portd l ] c@ $ 0f l ] and ] or [ portd l ] c! ] ;
: en-none ( -- ) $ c0 l ] en-put ] ;
: en-read ( -- ) $ e0 l ] en-put ] ;
: en-write ( -- ) $ 00 l ] en-put ] ;

: at-init-io ( -- ) ] address-out ] data-in ] en-none ] en-out ] ;

: at! ( c a -- ) ] data-out ] address-put ] en-write ] data-put ] en-none ] ;
: at@ ( a -- c ) ] data-in  ] address-put ] en-read  ] data-get ] en-none ] ;

: atcmd ( c -- )
  $ aa l $ 5555 l ] at!
  $ 55 l $ 2aaa l ] at!
         $ 5555 l ] at! ] ;

: atcmd-enable-protection  ( -- ) $ a0 l ] atcmd ] ;
: atcmd-disable-protection ( -- ) $ 80 l ] atcmd $ 20 l ] atcmd ] ;
: atcmd-enter-id   ( -- ) $ 90 l ] atcmd ( wait 10ms ) ] ;
: atcmd-exit-id    ( -- ) $ f0 l ] atcmd ( wait 10ms ) ] ;
: atcmd-lock   ( c a -- ) $ 80 l ] atcmd $ 40 l ] atcmd ] at! ] ;
: atcmd-lock-lower ( -- ) ( set first page ) $ 00 l $ 0000 l ] atcmd-enable-boot-lock ] ;
: atcmd-lock-upper ( -- ) ( set last page )  $ ff l $ ffff l ] atcmd-enable-boot-lock ] ;
: atcmd-erase      ( -- ) $ 80 l ] atcmd $ 10 l ] atcmd ( wait 20ms ) ] ;

: atcmd-manufacturer ( -- c ) $ 0000 l ] at@ ] ;
: atcmd-product      ( -- c ) $ 0001 l ] at@ ] ;

: atcmd-id ( -- product manufacturer )
  ] atcmd-enter-id
  ] atcmd-product
  ] atcmd-manufacturer
  ] atcmd-exit-id ] ;

$ 2 var at-num-sectors
$ 2 var at-sector-size
$ 2 var at-twait

: at-wait ( a x -- ) ] over ] at@ ] over ] - ] drop ] if ] pause ] at-wait ] ;
  ] then ] drop ] drop ] ;

: at-sector ( a1 a2 -- ) ] atcmd-enable-protection [ at-sector-size l ] @ ] for
    ] over ] c@ ] over ] at! ] swap ] 1+ ] swap ] 1+ ] next
  ] 1- ] swap ] 1- ] c@ ] at-wait ] ;

: sectors-per-bank ( -- u ) $ 8000 l [ at-sector-size l ] @ ] u/ ] ;

: bank! ( bank -- ) ] drop ] ;

: at-address-split ( sector -- address bank )
  ( todo: bank switching )
  [ at-sector-size l ] @ ] um*
  ] over $ 7fff l ] and ] -rot
  $ f l ] drshift ] drop ] ;

: at-sector@ ( sector a -- ) ] swap ] at-address-split ] bank! ] swap
  [ at-sector-size l ] @ ] for
    ] over ] at@ ] over ] c! ] swap ] 1+ ] swap ] 1+
  ] next ] 2drop ] ;

: at-sector! ( a sector -- ) ] at-address-split ] bank!
  ] atcmd-enable-protection [ at-sector-size l ] @ ] for
    ] over ] c@ ] over ] at! ] swap ] 1+ ] swap ] 1+
  ] next ] 1- ] swap ] 1- ] c@ ] at-wait ] ;

: at-get-size ( product -- num-sectors sector-size twait )
  $ dc l ] ? ] =if ] drop ." at29c256/7" $ 0200 l $ 0040 l $ 0a l ] ; ] then
  $ bc l ] ? ] =if ] drop ." at29lv256 " $ 0200 l $ 0040 l $ 14 l ] ; ] then
  $ 5d l ] ? ] =if ] drop ." at29c512  " $ 0200 l $ 0080 l $ 0a l ] ; ] then
  $ 3d l ] ? ] =if ] drop ." at29lv512 " $ 0200 l $ 0080 l $ 14 l ] ; ] then
  $ d5 l ] ? ] =if ] drop ." at29c010a " $ 0400 l $ 0080 l $ 0a l ] ; ] then
  $ 35 l ] ? ] =if ] drop ." at29lv010a" $ 0400 l $ 0080 l $ 14 l ] ; ] then
  $ 25 l ] ? ] =if ] drop ." at29c1024 " $ 0200 l $ 0080 l $ 0a l ] ; ] then
  $ 26 l ] ? ] =if ] drop ." at29lv1024" $ 0200 l $ 0080 l $ 14 l ] ; ] then
  $ da l ] ? ] =if ] drop ." at29c020  " $ 0400 l $ 0100 l $ 0a l ] ; ] then
  $ ba l ] ? ] =if ] drop ." at29lv020 " $ 0400 l $ 0100 l $ 14 l ] ; ] then
  $ 5b l ] ? ] =if ] drop ." at29c040  " $ 0400 l $ 0200 l $ 0a l ] ; ] then
  $ 3b l ] ? ] =if ] drop ." at29lv040 " $ 0400 l $ 0200 l $ 14 l ] ; ] then
  $ a4 l ] ? ] =if ] drop ." at29c040a " $ 0800 l $ 0100 l $ 0a l ] ; ] then
  $ c4 l ] ? ] =if ] drop ." at29lv040a" $ 0800 l $ 0100 l $ 14 l ] ; ] then
                          ." invalid   " $ 0000 l $ 0000 l $ 01 l ] ;
: at-check-atmel ( product manufacturer -- num-sectors sector-size twait )
  $ 1f l ] ? ] if ] drop ] drop ." not atmel" $ 0000 l $ 0000 l $ 01 l ] ;
  ] then ] drop ] at-get-size ] ;

: at-init-conf ( -- ) ] atcmd-id ] at-check-atmel
  [ at-twait l ] !
  [ at-sector-size l ] !
  [ at-num-sectors l ] ! ] ;

: at-init ( -- ) ] at-init-io ] at-init-conf ] ;

: at-dump1 ( a -- a' ) ] dup ] at@ ] b. ] 1+ ] ;
: at-dump10 ( a -- a' ) ] cr ] dup ] h. $ 10 l ] for ] at-dump1 ] next ] ;
: at-dump ( a n -- ) $ f l ] + $ 4 l ] rshift ] for ] at-dump10 ] next ] drop ] ;
  
