#ifndef VuvuzelaHero_H
#define VuvuzelaHero_H

#include <QtOpenGL>

#include "BGSpinner.h"

#include "SceneBase.h"

#ifndef SDLAUDIO
    #include <phonon/mediaobject.h>
#else
    #include "SDLSupport.h"
#endif

class VuvuzelaHero : public QGLWidget
{
Q_OBJECT
public:
    VuvuzelaHero();
    virtual ~VuvuzelaHero();
    
    bool initialize();
    
    void setScene(SceneBase*);
    
    void paintVuvuzela();
    
    //Draws our not-so-fancy text
    void drawText(QPainter& p, const QPoint &point, const QString& text);
    
protected:
    void paintGL();
    
protected slots:
    void timeout();
    void keyPressEvent(QKeyEvent*);
    void keyReleaseEvent(QKeyEvent*);
    
    void continueNoise();
    
private:
    SceneBase* m_scene;
    
    struct VecNor {
        QVector3D vector;
        QVector3D normal;
    };
    QList<VecNor>m_vuvuzelaVertices;
    QList<QList<int> >m_vuvuzelaTriangles;
    QList<QVector3D>m_vuvuzelaNormals;
    /*QTimer* m_timer;
    BGSpinner spinner;
    
    GLuint menubg;
    GLuint logo;*/
    
public:
    GLuint menubg;
    GLuint logo;
    GLuint grass;
    GLuint shadow;
    
    #ifndef SDLAUDIO
        Phonon::MediaObject* noise;
    #else
        SDLAudioObject* noise;
    #endif
};

#endif // VuvuzelaHero_H
