#include "Vuvuzela.h"

Vuvuzela::Vuvuzela()
{
    #ifndef SDLAUDIO
    m_object = new Phonon::MediaObject(this);
    m_output = new Phonon::AudioOutput(Phonon::GameCategory, this);
    Phonon::createPath(m_object, m_output);
    
    m_object->setTransitionTime(50);
    
    connect(m_object, SIGNAL(aboutToFinish()), this, SLOT(aboutToFinish()));
    #else
    for(uint32_t i = 0; i < 4; ++i){
        QString str;
        str.append("data/vuvuzela");
        str.append('1' + i); //Ugly hack
        str.append(".wav");
        m_audios[i] = new SDLAudioObject(this);
        if(!m_audios[i]->load(str)){
            qDebug() << "Failed to load " << str;
        }
    }
    #endif
}
Vuvuzela::~Vuvuzela()
{

}


void Vuvuzela::aboutToFinish()
{
    #ifndef SDLAUDIO
    if(m_note){
        QString str;
        str.append("data/vuvuzela");
        str.append('0' + m_note); //Ugly hack
        str.append(".wav");

        m_object->enqueue(Phonon::MediaSource(str));
    }
    #endif
}

void Vuvuzela::play(int note)
{
    #ifndef SDLAUDIO
    QString str;
    str.append("data/vuvuzela");
    str.append('0' + note); //Ugly hack
    str.append(".wav");
    
    m_object->setCurrentSource(Phonon::MediaSource(str));
    m_object->play();
    #else
    stop();
    m_audios[note - 1]->play();
    #endif
    
    m_note = note;
}

void Vuvuzela::delayedStop(int ms)
{
    #ifndef SDLAUDIO
    m_note = 0;
    QTimer::singleShot(ms, this, SLOT(stop()));
    #else
    for(uint32_t i = 0; i < 4; ++i){
        m_audios[i]->fade();
    }
    #endif
}

void Vuvuzela::stop()
{
    m_note = 0;
    
    #ifndef SDLAUDIO
    m_object->stop();
    #else
    for(uint32_t i = 0; i < 4; ++i){
        m_audios[i]->stop();
    }
    #endif
}



#include "Vuvuzela.moc"