#include "SongSelect.h"

#include "MainMenu.h"

#include "VuvuzelaHero.h"

SongSelect::SongSelect(FieldScene* scene, BGSpinner* spinner) : m_spinner(spinner), m_scene(scene), m_selected(0)
{

}
SongSelect::~SongSelect()
{

}

void SongSelect::start()
{
    connect(&m_timer, SIGNAL(timeout()), this, SLOT(timeout()));
    m_timer.start(20);
    m_spinner->start();
    m_time.start();
    
    vuvuzelaHero->noise->play();

}

void SongSelect::stop()
{
    //vuvuzelaHero->noise->stop();
}

void SongSelect::timeout()
{
    vuvuzelaHero->updateGL();
}


void SongSelect::keyPressEvent(QKeyEvent* e)
{
    if(e->key() == Qt::Key_Up){
        if(m_selected == 0)
            m_selected = Song::cache.size() - 1;
        else
            --m_selected;
    } else if(e->key() == Qt::Key_Down){
        if(m_selected == Song::cache.size() - 1)
            m_selected = 0;
        else
            ++m_selected;
    } else if(e->key() == Qt::Key_Return){
        if(!Song::cache.size()){
            return;
        }
        m_scene->setSong(&Song::cache[m_selected]);
        delete m_spinner;
        
        vuvuzelaHero->noise->pause();

        vuvuzelaHero->setScene(m_scene);
    } else if(e->key() == Qt::Key_Escape){
        delete m_scene;
        vuvuzelaHero->setScene(new MainMenu(m_spinner));
    }
}

void SongSelect::paint(QSize size)
{
    
    glViewport(0,0, size.width(), size.height());
    
    glColor3f(1.0, 1.0, 1.0);
    glClearColor(1,1,1, 1.0);
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
    
    glMatrixMode( GL_PROJECTION );
    glLoadIdentity( );
    glOrtho(0, size.width(), size.height(), 0, -1.0, 1.0);
    
    glMatrixMode(GL_MODELVIEW);
    
    glLoadIdentity();
    
    vuvuzelaHero->drawTexture(QRectF(0, 0, size.width(), size.height()), vuvuzelaHero->menubg);
    
    glMatrixMode( GL_PROJECTION );
    glPushMatrix();
    
    m_spinner->paint(size);
    
    QPainter p;
    p.begin(vuvuzelaHero);
    p.setFont(QFont("Sans", 40, QFont::Bold));
    
    float y = size.height() / 2 - p.fontMetrics().height() * m_selected;
    
    int num = 0;
    
    QList<Song>::iterator it = Song::cache.begin();
    while(it != Song::cache.end()){
        
        float x = size.width()/2 - p.fontMetrics().width(it->name)/2;
        
        if(m_selected == num){
            int32_t ms = (m_time.elapsed()/1000.0 - floor(m_time.elapsed()/1000.0)) * 1000 - 500;
        
            double diff;
            diff  = (pow(ms + (ms < 0 ? 250 : -250), 2));
            
            //250^2 = 62500
            diff -= 62500;
            
            if(ms < 0)
            diff *= -1;
          
            x += diff * 0.001;
        }
        
        vuvuzelaHero->drawText(p, QPoint(x,y), it->name);
        
        y += p.fontMetrics().height();
        ++num;
        ++it;
    }
    //p.setFont(QFont("Sans", 50, QFont::Bold));
    p.fillRect(0,0,size.width(),p.fontMetrics().height() + 20, QColor(225,102,0,200));
    
    vuvuzelaHero->drawText(p, QPoint(size.width() / 2.0 - p.fontMetrics().width("Select Song") / 2.0, p.fontMetrics().height()), "Select Song");
    
    p.end();
    
    glMatrixMode( GL_PROJECTION );
    glPopMatrix();
}



#include "SongSelect.moc"