#ifndef SongEditor_H
#define SongEditor_H

#include "BGSpinner.h"
#include "FieldScene.h"
#include "Vuvuzela.h"

class SongEditor : public FieldScene
{
Q_OBJECT
public:
    SongEditor();
    ~SongEditor();

    void start();
    void stop();
    
public slots:
    void keyPressEvent(QKeyEvent*);
    void keyReleaseEvent(QKeyEvent*);
    
    void paint(QSize size);
    
protected slots:
    void timeout();
    void clearmsg();

private:
    QTimer m_timer;
    BGSpinner m_spinner;
    
    QString m_msg;
    
    bool m_playing;
    double m_lastbeat;
    
    Vuvuzela m_vuvuzela;
    
    void noteSwitch(int);
};

#endif // SongEditor_H