#include "SDLSupport.h"

#include <QtCore>

SDLAudioObject::SDLAudioObject(QObject* parent) : QObject(parent), m_chunk(0), m_channel(-1)
{
}
SDLAudioObject::~SDLAudioObject()
{
    Mix_FreeChunk(m_chunk);
}

bool SDLAudioObject::load(const QString& file)
{
    m_chunk = Mix_LoadWAV(file.toStdString().c_str());
    if(!m_chunk){
        qDebug() << "Mix_LoadWav: " << Mix_GetError();
    }
    return true;
}
void SDLAudioObject::play()
{
    if(m_channel == -1){
        if((m_channel = Mix_PlayChannel(-1, m_chunk, -1)) == -1){
            qDebug() << "Mix_PlayChannel: " << Mix_GetError();
        }
    } else {
        Mix_Resume(m_channel);
    }
}
void SDLAudioObject::pause()
{
    Mix_HaltChannel(m_channel);
    m_channel = -1;
}
void SDLAudioObject::stop()
{
    Mix_HaltChannel(m_channel);
    m_channel = -1;
}

void SDLAudioObject::fade(int ms)
{
    Mix_FadeOutChannel(m_channel, ms);
    m_channel = -1;
}

bool initializeSDLAudio()
{

    if(SDL_Init(SDL_INIT_AUDIO|SDL_INIT_NOPARACHUTE) == -1){
        qDebug() << "Failed to initialize SDL: " << SDL_GetError();
        return false;
    }
    if(Mix_OpenAudio(44100, MIX_DEFAULT_FORMAT, 2, 1024) == -1){
        qDebug() << "Failed to initialize open SDL mixer audio: " << Mix_GetError();
        return false;
    }
    return true;
}
