#ifndef Game_H
#define Game_H

#include "BGSpinner.h"
#include "FieldScene.h"
#include "Vuvuzela.h"

#include <phonon/mediaobject.h>

class Game : public FieldScene
{
Q_OBJECT
public:
    Game();
    ~Game();

    void start();
    void stop();
    
public slots:
    void keyPressEvent(QKeyEvent*);
    void keyReleaseEvent(QKeyEvent*);
    
    void paint(QSize size);

protected slots:
    void timeout();
    
    void stopHilight();
    
public:
    int factor();
    
private:
    QTimer m_timer;
    bool m_beat_succeeded;
    double m_lastbeat;
    
    BGSpinner m_spinner;
    
    int m_score;
    int m_combo;
    
    bool m_missHilight;
    bool m_factorHilight;
    
    bool m_ask_exit;
    
    Vuvuzela m_vuvuzela;
    
    void noteSwitch(int);
};

#endif // Game_H