#include "FieldScene.h"


#include "VuvuzelaHero.h"

FieldScene::FieldScene() : beat(0.0), song(0), note(0)
{
    
}


FieldScene::~FieldScene()
{

}

void FieldScene::paintField(QSize size)
{
    QList<int>& beats = song->beats;
    
    
    glEnable(GL_DEPTH_TEST);
    glDepthFunc( GL_LEQUAL );
    glHint( GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST );
    
    glMatrixMode( GL_PROJECTION );
    glLoadIdentity( );
    gluPerspective(45.0f, ((double)size.width())/(size.height()), 0.1f, 100.0f);
        
    glMatrixMode(GL_MODELVIEW); 
    glLoadIdentity();
    
    gluLookAt(0, 5,-5, 0,0,0, 0,1,0);
    
    glTranslatef(0,0,-2);
    
    glColor3f(1.0, 1.0, 1.0);
        
    glDisable(GL_DEPTH_TEST);
    
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, vuvuzelaHero->grass);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
    
    bool darklast = (((int)floor(beat)) % 2 == 0 ? true : false);
    
    glPushMatrix();
  
    glScalef(4,1,1);
    glTranslatef(0,0,-(beat - floor(beat)) - 2);
    for(uint32_t i = 0; i < 20; ++i){
        
        glTranslatef(0,0,1);
        
        if(darklast){
            glColor3f(1.0, 1.0, 1.0);
            darklast = false;
        } else {
            glColor3f(.8, .8, .8);
            darklast = true;
        }
        
        /*glEnable(GL_COLOR_MATERIAL);
        glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );
        glEnable(GL_LIGHTING);
        glEnable (GL_LIGHT0);*/
        
        glBegin(GL_QUADS);
        glTexCoord2f(0,0);
        glVertex3f(-0.5,0,-0.5);
        glTexCoord2f(0,1);
        glVertex3f(-0.5,0,0.5);
        glTexCoord2f(1,1);
        glVertex3f(0.5,0,0.5);
        glTexCoord2f(1,0);
        glVertex3f(0.5,0,-0.5);
        glEnd();
        
        /*glDisable(GL_COLOR_MATERIAL);
        glDisable(GL_LIGHTING);
        glDisable(GL_LIGHT0);*/
    }
        
    glPopMatrix();
        
    glDisable(GL_TEXTURE_2D);

    glColor3f(1.0, 1.0, 1.0);

    glDisable(GL_DEPTH_TEST);
    
    glBegin(GL_QUADS);
    glVertex3f(2,0,-.1);
    glVertex3f(-2,0,-.1);
    glVertex3f(-2,0,.1);
    glVertex3f(2,0,.1);
    glEnd(); 
    
    glEnable(GL_BLEND);
    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    
    /*glBindTexture(GL_TEXTURE_2D, vuvuzelaHero->notes);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);*/
    
    
    glPushMatrix();
   
    //First drawn item recognizes being first and truncates itself if needed to "fit in" vuvuzela
    bool first = true;
    
    glTranslatef(0,0,-beat);

    if(floor(beat) < song->beats.size()){
    
        int now_beat = floor(beat);
        QList<int>::iterator it = beats.begin();
        it += floor(beat);
        glTranslatef(0,0,floor(beat));
        while(it != beats.end()){
            
            double x = (song->difficulty/2.0)-1;
            
            glDisable(GL_TEXTURE_2D);
            
            glColor3f(1.0,1.0,1.0);
            
            /*glBegin(GL_QUADS);
            glVertex3f(-2,0,-.01);
            glVertex3f(-2,0,.01);
            glVertex3f(2,0,.01);
            glVertex3f(2,0,-.01);
            glEnd();*/
            //glEnable(GL_TEXTURE_2D);
            
            if(now_beat >= 0 && now_beat < song->beats.size() && *it > 0 && *it <= song->difficulty){
                glPushMatrix();

                switch(*it){
                case 1:
                    glColor3f(0,0.75,0);
                    break;
                case 2:
                    glColor3f(0,0,0.75);
                    break;
                case 3:
                    glColor3f(0.75,0,0);
                    break;
                case 4:
                    glColor3f(0.75,0.75,0);
                    break;
                }
                
                //glColor3f(1,1,1);
                
                glEnable(GL_DEPTH_TEST);
                
                glTranslatef(x - *it + 1.5,.5,0);
                
                glEnable(GL_CULL_FACE);
                glCullFace(GL_BACK);
                glEnable(GL_COLOR_MATERIAL);
                glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );
                glEnable(GL_LIGHTING);
                glEnable (GL_LIGHT0);
                
                float mat_specular[] = {1.0f, 1.0f, 1.0f, 1.0};
                glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
                glMaterialf(GL_FRONT, GL_SHININESS, 100);
                
                
                GLUquadric* quad = gluNewQuadric();
                //gluQuadricTexture(quad, TRUE);
                
                float len = 1.0;
                if(first){
                    len = 1.0 - (beat - floor(beat));
                }
                
                if(*(it - 1) != *it || *(it + 1) != *it){
                    if(!first)
                        gluSphere(quad, 0.3, 32, 32);
                }
                
                if(*(it - 1) == *it || *(it + 1) == *it){
                    if(len < 1.0)
                        glTranslatef(0,0, 1.0 -len);
                    gluCylinder(quad, 0.3, 0.3, len, 64, 64);
                }
                
                
                gluDeleteQuadric(quad);
                
                
                glDisable(GL_LIGHTING);
                glDisable(GL_LIGHT0);
                glDisable(GL_CULL_FACE);
                glDisable(GL_COLOR_MATERIAL);
                //glDisable(GL_TEXTURE_2D);
                
                glPopMatrix();
                
                glPushMatrix();
                
                glTranslatef(x - *it + 1.0,0,0);
                
                if(*(it - 1) != *it || *(it + 1) != *it){
                    glColor3f(1,1,1);
                    glEnable(GL_TEXTURE_2D);
                    glBindTexture(GL_TEXTURE_2D, vuvuzelaHero->shadow);
                    
                    glBegin(GL_QUADS);
                    
                    if(*(it - 1) != *it){
                        glTexCoord2f(0, 0);
                        glVertex3f(1,0,-.5);
                        
                        glTexCoord2f(1, 0);
                        glVertex3f(0,0,-.5);
                    } else {
                        glTexCoord2f(0, .5);
                        glVertex3f(1,0,0);
                        
                        glTexCoord2f(1, .5);
                        glVertex3f(0,0,0);
                    }
                    
                    if(*(it + 1) != *it){
                        glTexCoord2f(1, 1);
                        glVertex3f(0,0,.5);
                        
                        glTexCoord2f(0, 1);
                        glVertex3f(1,0,.5);
                    } else {
                        glTexCoord2f(1, .5);
                        glVertex3f(0,0,0);
                        
                        glTexCoord2f(0, .5);
                        glVertex3f(1,0, 0);
                    }
                    glEnd();
                    
                }
                if(*(it - 1) == *it || *(it + 1) == *it){
                    glDisable(GL_TEXTURE_2D);
                    glColor4f(0,0,0,.8);
                    
                    glBegin(GL_QUADS);
                    if(*(it - 1) == *it){
                        glVertex3f(.85,0,-.5);
                        glVertex3f(.15,0,-.5);
                    } else {
                        glVertex3f(.85,0,0);
                        glVertex3f(.15,0,0);
                    }
                    if(*(it + 1) == *it){
                        glVertex3f(.15,0,.5);
                        glVertex3f(.85,0,.5);
                    } else {
                        glVertex3f(.15,0,0);
                        glVertex3f(.85,0,0);
                    }
                    glEnd();
                }
                
                glPopMatrix();
            }
            ++now_beat;
            first = false;
            glTranslatef(0,0,1);
            ++it;            
        }
    }
    glPopMatrix();
  
    glBindTexture(GL_TEXTURE_2D, vuvuzelaHero->shadow);
  
    double x = (song->difficulty/2.0) - 0.5;
  
    for(uint32_t i = 0; i < song->difficulty; ++i){
        
        glDisable(GL_DEPTH_TEST);
                
        glPushMatrix();
        glTranslatef(x, 0, .5);
        
        glColor3f(1,1,1);
        
        glEnable(GL_TEXTURE_2D);
        
        glBegin(GL_POLYGON);
            
        glTexCoord2f(1, 0);
        glVertex3f(-.5,0,-3);
        
        glTexCoord2f(0, .5);
        glVertex3f(-.5,0,-.5);
        
        
        glTexCoord2f(1, 1);
        glVertex3f(-.5,0,.5);
        
        glTexCoord2f(0, 1);
        glVertex3f(.5,0,.5);
        
        glTexCoord2f(0, .5);
        glVertex3f(.5,0, -.5);
        
        
        glTexCoord2f(0, 0);
        glVertex3f(.5,0,-3);
        
        glEnd();
        
        glDisable(GL_TEXTURE_2D);
        
        glPopMatrix();
        
        switch(i){
        case 0:
            glColor3f(0,0.6,0);
            break;
        case 1:
            glColor3f(0,0,0.6);
            break;
        case 2:
            glColor3f(0.6,0,0);
            break;
        case 3:
            glColor3f(0.6,0.6,0);
            break;
        }
        
        glPushMatrix();

        glTranslatef(x, .5, -.1);
        
        
        glScalef(0.8, 1.0, 0.8);
        
        if(((int)i + 1) == note){
            float factor = 1.0 + (qrand() % 5) / 10.0;
            glScalef(factor, factor, factor);
        }
        
        
        glEnable(GL_CULL_FACE);
        glCullFace(GL_BACK);
        glEnable(GL_COLOR_MATERIAL);
        glColorMaterial ( GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE );
        glEnable(GL_LIGHTING);
        glEnable (GL_LIGHT0);
        
        
        float mat_specular[] = {.4f, .4f, .4f, 1.0};
        glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
        glMaterialf(GL_FRONT, GL_SHININESS, 5);
        
        glEnable(GL_DEPTH_TEST);
        
        vuvuzelaHero->paintVuvuzela();
        
        glDisable(GL_LIGHTING);
        glDisable(GL_LIGHT0);
        glDisable(GL_CULL_FACE);
        glDisable(GL_COLOR_MATERIAL);
        
        
        glPopMatrix();
        
        --x;
    }
  
    glDisable(GL_BLEND);
    
    //printf("%x\n",glGetError());
}

void FieldScene::setSong(Song* song){
    this->song = song;
}



#include "FieldScene.moc"